extends Shape3D
class_name HeightMapShape3D

## A 3D height map shape used for physics collision.
##
## A 3D heightmap shape, intended for use in physics. Usually used to provide a shape for a [CollisionShape3D]. This is useful for terrain, but it is limited as overhangs (such as caves) cannot be stored. Holes in a [HeightMapShape3D] are created by assigning very low values to points in the desired area.
## [b]Performance:[/b] [HeightMapShape3D] is faster to check collisions against than [ConcavePolygonShape3D], but it is significantly slower than primitive shapes like [BoxShape3D].



## Height map data, pool array must be of [member map_width] * [member map_depth] size.
var map_data: PackedFloat32Array:
	get = get_map_data, set = set_map_data

## Number of vertices in the depth of the height map. Changing this will resize the [member map_data].
var map_depth: int:
	get = get_map_depth, set = set_map_depth

## Number of vertices in the width of the height map. Changing this will resize the [member map_data].
var map_width: int:
	get = get_map_width, set = set_map_width




func get_map_data() -> PackedFloat32Array:
	return map_data

func set_map_data(value: PackedFloat32Array) -> void:
	map_data = value

func get_map_depth() -> int:
	return map_depth

func set_map_depth(value: int) -> void:
	map_depth = value

func get_map_width() -> int:
	return map_width

func set_map_width(value: int) -> void:
	map_width = value

