extends Container
class_name GridContainer

## A container that arranges its child controls in a grid layout.
##
## [GridContainer] arranges its child controls in a grid layout. The number of columns is specified by the [member columns] property, whereas the number of rows depends on how many are needed for the child controls. The number of rows and columns is preserved for every size of the container.
## [b]Note:[/b] [GridContainer] only works with child nodes inheriting from [Control]. It won't rearrange child nodes inheriting from [Node2D].
##
## @tutorial(Using Containers): https://docs.godotengine.org/en/stable/tutorials/ui/gui_containers.html
## @tutorial(OS Test Demo): https://godotengine.org/asset-library/asset/677



## The number of columns in the [GridContainer]. If modified, [GridContainer] reorders its Control-derived children to accommodate the new layout.
var columns: int:
	get = get_columns, set = set_columns




func get_columns() -> int:
	return columns

func set_columns(value: int) -> void:
	columns = value

