extends ConfirmationDialog
class_name EditorCommandPalette

## Godot editor's command palette.
##
## Object that holds all the available Commands and their shortcuts text. These Commands can be accessed through [b]Editor > Command Palette[/b] menu.
## Command key names use slash delimiters to distinguish sections, for example: [code]"example/command1"[/code] then [code]example[/code] will be the section name.
## [codeblocks]
## [gdscript]
## var command_palette = get_editor_interface().get_command_palette()
## # external_command is a function that will be called with the command is executed.
## var command_callable = Callable(self, "external_command").bind(arguments)
## command_palette.add_command("command", "test/command",command_callable)
## [/gdscript]
## [csharp]
## EditorCommandPalette commandPalette = GetEditorInterface().GetCommandPalette();
## // ExternalCommand is a function that will be called with the command is executed.
## Callable commandCallable = new Callable(this, MethodName.ExternalCommand);
## commandPalette.AddCommand("command", "test/command", commandCallable)
## [/csharp]
## [/codeblocks]
## [b]Note:[/b] This class shouldn't be instantiated directly. Instead, access the singleton using [method EditorInterface.get_command_palette].



var dialog_hide_on_ok: bool:
	get = get_hide_on_ok, set = set_hide_on_ok



## Adds a custom command to EditorCommandPalette.
## - [param command_name]: [String] (Name of the [b]Command[/b]. This is displayed to the user.)
## - [param key_name]: [String] (Name of the key for a particular [b]Command[/b]. This is used to uniquely identify the [b]Command[/b].)
## - [param binded_callable]: [Callable] (Callable of the [b]Command[/b]. This will be executed when the [b]Command[/b] is selected.)
## - [param shortcut_text]: [String] (Shortcut text of the [b]Command[/b] if available.)
func add_command(command_name: String, key_name: String, binded_callable: Callable, shortcut_text: String = "None") -> void:
	pass;

## Removes the custom command from EditorCommandPalette.
## - [param key_name]: [String] (Name of the key for a particular [b]Command[/b].)
func remove_command(key_name: String) -> void:
	pass;


func get_hide_on_ok() -> bool:
	return dialog_hide_on_ok

func set_hide_on_ok(value: bool) -> void:
	dialog_hide_on_ok = value

