extends Resource
class_name AudioStream

## Base class for audio streams.
##
## Base class for audio streams. Audio streams are used for sound effects and music playback, and support WAV (via [AudioStreamWAV]) and Ogg (via [AudioStreamOggVorbis]) file formats.
##
## @tutorial(Audio streams): https://docs.godotengine.org/en/stable/tutorials/audio/audio_streams.html
## @tutorial(Audio Generator Demo): https://godotengine.org/asset-library/asset/526
## @tutorial(Audio Mic Record Demo): https://godotengine.org/asset-library/asset/527
## @tutorial(Audio Spectrum Demo): https://godotengine.org/asset-library/asset/528





func _get_beat_count() -> int:
	pass;

func _get_bpm() -> float:
	pass;

func _get_length() -> float:
	pass;

func _get_stream_name() -> String:
	pass;

func _instantiate_playback() -> AudioStreamPlayback:
	pass;

func _is_monophonic() -> bool:
	pass;

## Returns the length of the audio stream in seconds.
func get_length() -> float:
	pass;

## Returns an AudioStreamPlayback. Useful for when you want to extend [method _instantiate_playback] but call [method instantiate_playback] from an internally held AudioStream subresource. An example of this can be found in the source files for [code]AudioStreamRandomPitch::instantiate_playback[/code].
func instantiate_playback() -> AudioStreamPlayback:
	pass;

## Returns true if this audio stream only supports monophonic playback, or false if the audio stream supports polyphony.
func is_monophonic() -> bool:
	pass;


