extends ScrollBar
class_name VScrollBar

## A vertical scrollbar that goes from top (min) to bottom (max).
##
## A vertical scrollbar, typically used to navigate through content that extends beyond the visible height of a control. It is a [Range]-based control and goes from top (min) to bottom (max). Note that this direction is the opposite of [VSlider]'s.



var size_flags_horizontal: int:
	get = get_h_size_flags, set = set_h_size_flags

var size_flags_vertical: int:
	get = get_v_size_flags, set = set_v_size_flags




func get_h_size_flags() -> int:
	return size_flags_horizontal

func set_h_size_flags(value: int) -> void:
	size_flags_horizontal = value

func get_v_size_flags() -> int:
	return size_flags_vertical

func set_v_size_flags(value: int) -> void:
	size_flags_vertical = value

