extends Resource
class_name SkeletonModificationStack2D

## A resource that holds a stack of [SkeletonModification2D]s.
##
## This resource is used by the Skeleton and holds a stack of [SkeletonModification2D]s.
## This controls the order of the modifications and how they are applied. Modification order is especially important for full-body IK setups, as you need to execute the modifications in the correct order to get the desired results. For example, you want to execute a modification on the spine [i]before[/i] the arms on a humanoid skeleton.
## This resource also controls how strongly all of the modifications are applied to the [Skeleton2D].
## @experimental



## If [code]true[/code], the modification's in the stack will be called. This is handled automatically through the [Skeleton2D] node.
var enabled: bool:
	get = get_enabled, set = set_enabled

## The number of modifications in the stack.
var modification_count: int:
	get = get_modification_count, set = set_modification_count

## The interpolation strength of the modifications in stack. A value of [code]0[/code] will make it where the modifications are not applied, a strength of [code]0.5[/code] will be half applied, and a strength of [code]1[/code] will allow the modifications to be fully applied and override the [Skeleton2D] [Bone2D] poses.
var strength: float:
	get = get_strength, set = set_strength



## Adds the passed-in [SkeletonModification2D] to the stack.
func add_modification(modification: SkeletonModification2D) -> void:
	pass;

## Deletes the [SkeletonModification2D] at the index position [param mod_idx], if it exists.
func delete_modification(mod_idx: int) -> void:
	pass;

## Enables all [SkeletonModification2D]s in the stack.
func enable_all_modifications(enabled: bool) -> void:
	pass;

## Executes all of the [SkeletonModification2D]s in the stack that use the same execution mode as the passed-in [param execution_mode], starting from index [code]0[/code] to [member modification_count].
## [b]Note:[/b] The order of the modifications can matter depending on the modifications. For example, modifications on a spine should operate before modifications on the arms in order to get proper results.
func execute(delta: float, execution_mode: int) -> void:
	pass;

## Returns a boolean that indicates whether the modification stack is setup and can execute.
func get_is_setup() -> bool:
	pass;

## Returns the [SkeletonModification2D] at the passed-in index, [param mod_idx].
func get_modification(mod_idx: int) -> SkeletonModification2D:
	pass;

## Returns the [Skeleton2D] node that the SkeletonModificationStack2D is bound to.
func get_skeleton() -> Skeleton2D:
	pass;

## Sets the modification at [param mod_idx] to the passed-in modification, [param modification].
func set_modification(mod_idx: int, modification: SkeletonModification2D) -> void:
	pass;

## Sets up the modification stack so it can execute. This function should be called by [Skeleton2D] and shouldn't be manually called unless you know what you are doing.
func setup() -> void:
	pass;


func get_enabled() -> bool:
	return enabled

func set_enabled(value: bool) -> void:
	enabled = value

func get_modification_count() -> int:
	return modification_count

func set_modification_count(value: int) -> void:
	modification_count = value

func get_strength() -> float:
	return strength

func set_strength(value: float) -> void:
	strength = value

