extends Node2D
class_name Skeleton2D

## The parent of a hierarchy of [Bone2D]s, used to create a 2D skeletal animation.
##
## [Skeleton2D] parents a hierarchy of [Bone2D] nodes. It holds a reference to each [Bone2D]'s rest pose and acts as a single point of access to its bones.
## To set up different types of inverse kinematics for the given Skeleton2D, a [SkeletonModificationStack2D] should be created. The inverse kinematics be applied by increasing [member SkeletonModificationStack2D.modification_count] and creating the desired number of modifications.
##
## @tutorial(2D skeletons): https://docs.godotengine.org/en/stable/tutorials/animation/2d_skeletons.html


## Emitted when the [Bone2D] setup attached to this skeletons changes. This is primarily used internally within the skeleton.
signal bone_setup_changed



## Executes all the modifications on the [SkeletonModificationStack2D], if the Skeleton2D has one assigned.
func execute_modifications(delta: float, execution_mode: int) -> void:
	pass;

## Returns a [Bone2D] from the node hierarchy parented by Skeleton2D. The object to return is identified by the parameter [param idx]. Bones are indexed by descending the node hierarchy from top to bottom, adding the children of each branch before moving to the next sibling.
func get_bone(idx: int) -> Bone2D:
	pass;

## Returns the number of [Bone2D] nodes in the node hierarchy parented by Skeleton2D.
func get_bone_count() -> int:
	pass;

## Returns the local pose override transform for [param bone_idx].
func get_bone_local_pose_override(bone_idx: int) -> Transform2D:
	pass;

## Returns the [SkeletonModificationStack2D] attached to this skeleton, if one exists.
func get_modification_stack() -> SkeletonModificationStack2D:
	pass;

## Returns the [RID] of a Skeleton2D instance.
func get_skeleton() -> RID:
	pass;

## Sets the local pose transform, [param override_pose], for the bone at [param bone_idx].
## [param strength] is the interpolation strength that will be used when applying the pose, and [param persistent] determines if the applied pose will remain.
## [b]Note:[/b] The pose transform needs to be a local transform relative to the [Bone2D] node at [param bone_idx]!
func set_bone_local_pose_override(bone_idx: int, override_pose: Transform2D, strength: float, persistent: bool) -> void:
	pass;

## Sets the [SkeletonModificationStack2D] attached to this skeleton.
func set_modification_stack(modification_stack: SkeletonModificationStack2D) -> void:
	pass;


