extends Resource
class_name NavigationPolygon

## A navigation polygon that defines traversable areas and obstacles.
##
## There are two ways to create polygons. Either by using the [method add_outline] method, or using the [method add_polygon] method.
## Using [method add_outline]:
## [codeblocks]
## [gdscript]
## var polygon = NavigationPolygon.new()
## var outline = PackedVector2Array([Vector2(0, 0), Vector2(0, 50), Vector2(50, 50), Vector2(50, 0)])
## polygon.add_outline(outline)
## polygon.make_polygons_from_outlines()
## $NavigationRegion2D.navigation_polygon = polygon
## [/gdscript]
## [csharp]
## var polygon = new NavigationPolygon();
## var outline = new Vector2[] { new Vector2(0, 0), new Vector2(0, 50), new Vector2(50, 50), new Vector2(50, 0) };
## polygon.AddOutline(outline);
## polygon.MakePolygonsFromOutlines();
## GetNode<NavigationRegion2D>("NavigationRegion2D").NavigationPolygon = polygon;
## [/csharp]
## [/codeblocks]
## Using [method add_polygon] and indices of the vertices array.
## [codeblocks]
## [gdscript]
## var polygon = NavigationPolygon.new()
## var vertices = PackedVector2Array([Vector2(0, 0), Vector2(0, 50), Vector2(50, 50), Vector2(50, 0)])
## polygon.vertices = vertices
## var indices = PackedInt32Array([0, 1, 2, 3])
## polygon.add_polygon(indices)
## $NavigationRegion2D.navigation_polygon = polygon
## [/gdscript]
## [csharp]
## var polygon = new NavigationPolygon();
## var vertices = new Vector2[] { new Vector2(0, 0), new Vector2(0, 50), new Vector2(50, 50), new Vector2(50, 0) };
## polygon.Vertices = vertices;
## var indices = new int[] { 0, 1, 2, 3 };
## polygon.AddPolygon(indices);
## GetNode<NavigationRegion2D>("NavigationRegion2D").NavigationPolygon = polygon;
## [/csharp]
## [/codeblocks]
##
## @tutorial(2D Navigation Demo): https://godotengine.org/asset-library/asset/117
## @tutorial(Using NavigationMeshes): https://docs.godotengine.org/en/stable/tutorials/navigation/navigation_using_navigationmeshes.html
## @experimental



## The cell size used to rasterize the navigation mesh vertices. Must match with the cell size on the navigation map.
var cell_size: float:
	get = get_cell_size, set = set_cell_size



## Appends a [PackedVector2Array] that contains the vertices of an outline to the internal array that contains all the outlines. You have to call [method make_polygons_from_outlines] in order for this array to be converted to polygons that the engine will use.
func add_outline(outline: PackedVector2Array) -> void:
	pass;

## Adds a [PackedVector2Array] that contains the vertices of an outline to the internal array that contains all the outlines at a fixed position. You have to call [method make_polygons_from_outlines] in order for this array to be converted to polygons that the engine will use.
func add_outline_at_index(outline: PackedVector2Array, index: int) -> void:
	pass;

## Adds a polygon using the indices of the vertices you get when calling [method get_vertices].
func add_polygon(polygon: PackedInt32Array) -> void:
	pass;

## Clears the array of the outlines, but it doesn't clear the vertices and the polygons that were created by them.
func clear_outlines() -> void:
	pass;

## Clears the array of polygons, but it doesn't clear the array of outlines and vertices.
func clear_polygons() -> void:
	pass;

## Returns the [NavigationMesh] resulting from this navigation polygon. This navigation mesh can be used to update the navigation mesh of a region with the [method NavigationServer3D.region_set_navigation_mesh] API directly (as 2D uses the 3D server behind the scene).
func get_navigation_mesh() -> NavigationMesh:
	pass;

## Returns a [PackedVector2Array] containing the vertices of an outline that was created in the editor or by script.
func get_outline(idx: int) -> PackedVector2Array:
	pass;

## Returns the number of outlines that were created in the editor or by script.
func get_outline_count() -> int:
	pass;

## Returns a [PackedInt32Array] containing the indices of the vertices of a created polygon.
func get_polygon(idx: int) -> PackedInt32Array:
	pass;

## Returns the count of all polygons.
func get_polygon_count() -> int:
	pass;

## Returns a [PackedVector2Array] containing all the vertices being used to create the polygons.
func get_vertices() -> PackedVector2Array:
	pass;

## Creates polygons from the outlines added in the editor or by script.
func make_polygons_from_outlines() -> void:
	pass;

## Removes an outline created in the editor or by script. You have to call [method make_polygons_from_outlines] for the polygons to update.
func remove_outline(idx: int) -> void:
	pass;

## Changes an outline created in the editor or by script. You have to call [method make_polygons_from_outlines] for the polygons to update.
func set_outline(idx: int, outline: PackedVector2Array) -> void:
	pass;

## Sets the vertices that can be then indexed to create polygons with the [method add_polygon] method.
func set_vertices(vertices: PackedVector2Array) -> void:
	pass;


func get_cell_size() -> float:
	return cell_size

func set_cell_size(value: float) -> void:
	cell_size = value

