extends VisualShaderNodeParameter
class_name VisualShaderNodeVec3Parameter

## A [Vector3] parameter to be used within the visual shader graph.
##
## Translated to [code]uniform vec3[/code] in the shader language.



## A default value to be assigned within the shader.
var default_value: Vector3:
	get = get_default_value, set = set_default_value

## Enables usage of the [member default_value].
var default_value_enabled: bool:
	get = is_default_value_enabled, set = set_default_value_enabled




func get_default_value() -> Vector3:
	return default_value

func set_default_value(value: Vector3) -> void:
	default_value = value

func is_default_value_enabled() -> bool:
	return default_value_enabled

func set_default_value_enabled(value: bool) -> void:
	default_value_enabled = value

