extends Object
class_name PhysicsDirectBodyState3D

## Direct access object to a physics body in the [PhysicsServer3D].
##
## Provides direct access to a physics body in the [PhysicsServer3D], allowing safe changes to physics properties. This object is passed via the direct state callback of rigid bodies, and is intended for changing the direct state of that body. See [method RigidBody3D._integrate_forces].
##
## @tutorial(Physics introduction): https://docs.godotengine.org/en/stable/tutorials/physics/physics_introduction.html
## @tutorial(Ray-casting): https://docs.godotengine.org/en/stable/tutorials/physics/ray-casting.html



## The body's rotational velocity in [i]radians[/i] per second.
var angular_velocity: Vector3:
	get = get_angular_velocity, set = set_angular_velocity

## The body's center of mass position relative to the body's center in the global coordinate system.
var center_of_mass: Vector3:
	get = get_center_of_mass

## The body's center of mass position in the body's local coordinate system.
var center_of_mass_local: Vector3:
	get = get_center_of_mass_local

## The inverse of the inertia of the body.
var inverse_inertia: Vector3:
	get = get_inverse_inertia

## The inverse of the inertia tensor of the body.
var inverse_inertia_tensor: Basis:
	get = get_inverse_inertia_tensor

## The inverse of the mass of the body.
var inverse_mass: float:
	get = get_inverse_mass

## The body's linear velocity in units per second.
var linear_velocity: Vector3:
	get = get_linear_velocity, set = set_linear_velocity

var principal_inertia_axes: Basis:
	get = get_principal_inertia_axes

## If [code]true[/code], this body is currently sleeping (not active).
var sleeping: bool:
	get = is_sleeping, set = set_sleep_state

## The timestep (delta) used for the simulation.
var step: float:
	get = get_step

## The rate at which the body stops rotating, if there are not any other forces moving it.
var total_angular_damp: float:
	get = get_total_angular_damp

## The total gravity vector being currently applied to this body.
var total_gravity: Vector3:
	get = get_total_gravity

## The rate at which the body stops moving, if there are not any other forces moving it.
var total_linear_damp: float:
	get = get_total_linear_damp

## The body's transformation matrix.
var transform: Transform3D:
	get = get_transform, set = set_transform



## Adds a constant directional force without affecting rotation that keeps being applied over time until cleared with [code]constant_force = Vector3(0, 0, 0)[/code].
## This is equivalent to using [method add_constant_force] at the body's center of mass.
func add_constant_central_force(force: Vector3 = Vector3(0, 0, 0)) -> void:
	pass;

## Adds a constant positioned force to the body that keeps being applied over time until cleared with [code]constant_force = Vector3(0, 0, 0)[/code].
## [param position] is the offset from the body origin in global coordinates.
func add_constant_force(force: Vector3, position: Vector3 = Vector3(0, 0, 0)) -> void:
	pass;

## Adds a constant rotational force without affecting position that keeps being applied over time until cleared with [code]constant_torque = Vector3(0, 0, 0)[/code].
func add_constant_torque(torque: Vector3) -> void:
	pass;

## Applies a directional force without affecting rotation. A force is time dependent and meant to be applied every physics update.
## This is equivalent to using [method apply_force] at the body's center of mass.
func apply_central_force(force: Vector3 = Vector3(0, 0, 0)) -> void:
	pass;

## Applies a directional impulse without affecting rotation.
## An impulse is time-independent! Applying an impulse every frame would result in a framerate-dependent force. For this reason, it should only be used when simulating one-time impacts (use the "_force" functions otherwise).
## This is equivalent to using [method apply_impulse] at the body's center of mass.
func apply_central_impulse(impulse: Vector3 = Vector3(0, 0, 0)) -> void:
	pass;

## Applies a positioned force to the body. A force is time dependent and meant to be applied every physics update.
## [param position] is the offset from the body origin in global coordinates.
func apply_force(force: Vector3, position: Vector3 = Vector3(0, 0, 0)) -> void:
	pass;

## Applies a positioned impulse to the body.
## An impulse is time-independent! Applying an impulse every frame would result in a framerate-dependent force. For this reason, it should only be used when simulating one-time impacts (use the "_force" functions otherwise).
## [param position] is the offset from the body origin in global coordinates.
func apply_impulse(impulse: Vector3, position: Vector3 = Vector3(0, 0, 0)) -> void:
	pass;

## Applies a rotational force without affecting position. A force is time dependent and meant to be applied every physics update.
## [b]Note:[/b] [member inverse_inertia] is required for this to work. To have [member inverse_inertia], an active [CollisionShape3D] must be a child of the node, or you can manually set [member inverse_inertia].
func apply_torque(torque: Vector3) -> void:
	pass;

## Applies a rotational impulse to the body without affecting the position.
## An impulse is time-independent! Applying an impulse every frame would result in a framerate-dependent force. For this reason, it should only be used when simulating one-time impacts (use the "_force" functions otherwise).
## [b]Note:[/b] [member inverse_inertia] is required for this to work. To have [member inverse_inertia], an active [CollisionShape3D] must be a child of the node, or you can manually set [member inverse_inertia].
func apply_torque_impulse(impulse: Vector3) -> void:
	pass;

## Returns the body's total constant positional forces applied during each physics update.
## See [method add_constant_force] and [method add_constant_central_force].
func get_constant_force() -> Vector3:
	pass;

## Returns the body's total constant rotational forces applied during each physics update.
## See [method add_constant_torque].
func get_constant_torque() -> Vector3:
	pass;

## Returns the collider's [RID].
func get_contact_collider(contact_idx: int) -> RID:
	pass;

## Returns the collider's object id.
func get_contact_collider_id(contact_idx: int) -> int:
	pass;

## Returns the collider object.
func get_contact_collider_object(contact_idx: int) -> Object:
	pass;

## Returns the contact position in the collider.
func get_contact_collider_position(contact_idx: int) -> Vector3:
	pass;

## Returns the collider's shape index.
func get_contact_collider_shape(contact_idx: int) -> int:
	pass;

## Returns the linear velocity vector at the collider's contact point.
func get_contact_collider_velocity_at_position(contact_idx: int) -> Vector3:
	pass;

## Returns the number of contacts this body has with other bodies.
## [b]Note:[/b] By default, this returns 0 unless bodies are configured to monitor contacts. See [member RigidBody3D.contact_monitor].
func get_contact_count() -> int:
	pass;

## Impulse created by the contact.
func get_contact_impulse(contact_idx: int) -> Vector3:
	pass;

## Returns the local normal at the contact point.
func get_contact_local_normal(contact_idx: int) -> Vector3:
	pass;

## Returns the local position of the contact point.
func get_contact_local_position(contact_idx: int) -> Vector3:
	pass;

## Returns the local shape index of the collision.
func get_contact_local_shape(contact_idx: int) -> int:
	pass;

## Returns the current state of the space, useful for queries.
func get_space_state() -> PhysicsDirectSpaceState3D:
	pass;

## Returns the body's velocity at the given relative position, including both translation and rotation.
func get_velocity_at_local_position(local_position: Vector3) -> Vector3:
	pass;

## Calls the built-in force integration code.
func integrate_forces() -> void:
	pass;

## Sets the body's total constant positional forces applied during each physics update.
## See [method add_constant_force] and [method add_constant_central_force].
func set_constant_force(force: Vector3) -> void:
	pass;

## Sets the body's total constant rotational forces applied during each physics update.
## See [method add_constant_torque].
func set_constant_torque(torque: Vector3) -> void:
	pass;


func get_angular_velocity() -> Vector3:
	return angular_velocity

func set_angular_velocity(value: Vector3) -> void:
	angular_velocity = value

func get_center_of_mass() -> Vector3:
	return center_of_mass

func get_center_of_mass_local() -> Vector3:
	return center_of_mass_local

func get_inverse_inertia() -> Vector3:
	return inverse_inertia

func get_inverse_inertia_tensor() -> Basis:
	return inverse_inertia_tensor

func get_inverse_mass() -> float:
	return inverse_mass

func get_linear_velocity() -> Vector3:
	return linear_velocity

func set_linear_velocity(value: Vector3) -> void:
	linear_velocity = value

func get_principal_inertia_axes() -> Basis:
	return principal_inertia_axes

func is_sleeping() -> bool:
	return sleeping

func set_sleep_state(value: bool) -> void:
	sleeping = value

func get_step() -> float:
	return step

func get_total_angular_damp() -> float:
	return total_angular_damp

func get_total_gravity() -> Vector3:
	return total_gravity

func get_total_linear_damp() -> float:
	return total_linear_damp

func get_transform() -> Transform3D:
	return transform

func set_transform(value: Transform3D) -> void:
	transform = value

