extends TextureLayered
class_name ImageTextureLayered

## Base class for texture types which contain the data of multiple [ImageTexture]s. Each image is of the same size and format.
##
## Base class for [Texture2DArray], [Cubemap] and [CubemapArray]. Cannot be used directly, but contains all the functions necessary for accessing the derived resource types. See also [Texture3D].





## Creates an [ImageTextureLayered] from an array of [Image]s. See [method Image.create] for the expected data format. The first image decides the width, height, image format and mipmapping setting. The other images [i]must[/i] have the same width, height, image format and mipmapping setting.
## Each [Image] represents one [code]layer[/code].
func create_from_images(images: Array[Image]) -> int:
	pass;

## Replaces the existing [Image] data at the given [code]layer[/code] with this new image.
## The given [Image] must have the same width, height, image format and mipmapping setting (a [code]bool[/code] value) as the rest of the referenced images.
## If the image format is unsupported, it will be decompressed and converted to a similar and supported [enum Image.Format].
## The update is immediate: it's synchronized with drawing.
func update_layer(image: Image, layer: int) -> void:
	pass;


