extends Resource
class_name GLTFState



## Discards all embedded textures and uses untextured materials.
const HANDLE_BINARY_DISCARD_TEXTURES = 0;

## Extracts embedded textures to be reimported and compressed. Editor only. Acts as uncompressed at runtime.
const HANDLE_BINARY_EXTRACT_TEXTURES = 1;

## Embeds textures VRAM compressed with Basis Universal into the generated scene.
const HANDLE_BINARY_EMBED_AS_BASISU = 2;

## Embeds textures compressed losslessly into the generated scene, matching old behavior.
const HANDLE_BINARY_EMBED_AS_UNCOMPRESSED = 3;


var base_path: String:
	get = get_base_path, set = set_base_path

var buffers: Array[PackedByteArray]:
	get = get_buffers, set = set_buffers

var create_animations: bool:
	get = get_create_animations, set = set_create_animations

var glb_data: PackedByteArray:
	get = get_glb_data, set = set_glb_data

var json: Dictionary:
	get = get_json, set = set_json

var major_version: int:
	get = get_major_version, set = set_major_version

var minor_version: int:
	get = get_minor_version, set = set_minor_version

var root_nodes: PackedInt32Array:
	get = get_root_nodes, set = set_root_nodes

var scene_name: String:
	get = get_scene_name, set = set_scene_name

var use_named_skin_binds: bool:
	get = get_use_named_skin_binds, set = set_use_named_skin_binds



## Appends an extension to the list of extensions used by this GLTF file during serialization. If [param required] is true, the extension will also be added to the list of required extensions. Do not run this in [method GLTFDocumentExtension._export_post], as that stage is too late to add extensions. The final list is sorted alphabetically.
func add_used_extension(extension_name: String, required: bool) -> void:
	pass;

func get_accessors() -> Array[GLTFAccessor]:
	pass;

## Gets additional arbitrary data in this [GLTFState] instance. This can be used to keep per-file state data in [GLTFDocumentExtension] classes, which is important because they are stateless.
## The argument should be the [GLTFDocumentExtension] name (does not have to match the extension name in the GLTF file), and the return value can be anything you set. If nothing was set, the return value is null.
func get_additional_data(extension_name: StringName) -> Variant:
	pass;

func get_animation_player(idx: int) -> AnimationPlayer:
	pass;

func get_animation_players_count(idx: int) -> int:
	pass;

func get_animations() -> Array[GLTFAnimation]:
	pass;

func get_buffer_views() -> Array[GLTFBufferView]:
	pass;

func get_cameras() -> Array[GLTFCamera]:
	pass;

func get_handle_binary_image() -> int:
	pass;

func get_images() -> Array[Texture2D]:
	pass;

func get_lights() -> Array[GLTFLight]:
	pass;

func get_materials() -> Array[Material]:
	pass;

func get_meshes() -> Array[GLTFMesh]:
	pass;

func get_nodes() -> Array[GLTFNode]:
	pass;

func get_scene_node(idx: int) -> Node:
	pass;

func get_skeletons() -> Array[GLTFSkeleton]:
	pass;

func get_skins() -> Array[GLTFSkin]:
	pass;

## Retrieves the array of texture samplers that are used by the textures contained in the GLTF.
func get_texture_samplers() -> Array[GLTFTextureSampler]:
	pass;

func get_textures() -> Array[GLTFTexture]:
	pass;

func get_unique_animation_names() -> Array[String]:
	pass;

func get_unique_names() -> Array[String]:
	pass;

func set_accessors(accessors: Array[GLTFAccessor]) -> void:
	pass;

## Sets additional arbitrary data in this [GLTFState] instance. This can be used to keep per-file state data in [GLTFDocumentExtension] classes, which is important because they are stateless.
## The first argument should be the [GLTFDocumentExtension] name (does not have to match the extension name in the GLTF file), and the second argument can be anything you want.
func set_additional_data(extension_name: StringName, additional_data: Variant) -> void:
	pass;

func set_animations(animations: Array[GLTFAnimation]) -> void:
	pass;

func set_buffer_views(buffer_views: Array[GLTFBufferView]) -> void:
	pass;

func set_cameras(cameras: Array[GLTFCamera]) -> void:
	pass;

func set_handle_binary_image(method: int) -> void:
	pass;

func set_images(images: Array[Texture2D]) -> void:
	pass;

func set_lights(lights: Array[GLTFLight]) -> void:
	pass;

func set_materials(materials: Array[Material]) -> void:
	pass;

func set_meshes(meshes: Array[GLTFMesh]) -> void:
	pass;

func set_nodes(nodes: Array[GLTFNode]) -> void:
	pass;

func set_skeletons(skeletons: Array[GLTFSkeleton]) -> void:
	pass;

func set_skins(skins: Array[GLTFSkin]) -> void:
	pass;

## Sets the array of texture samplers that are used by the textures contained in the GLTF.
func set_texture_samplers(texture_samplers: Array[GLTFTextureSampler]) -> void:
	pass;

func set_textures(textures: Array[GLTFTexture]) -> void:
	pass;

func set_unique_animation_names(unique_animation_names: Array[String]) -> void:
	pass;

func set_unique_names(unique_names: Array[String]) -> void:
	pass;


func get_base_path() -> String:
	return base_path

func set_base_path(value: String) -> void:
	base_path = value

func get_buffers() -> Array[PackedByteArray]:
	return buffers

func set_buffers(value: Array[PackedByteArray]) -> void:
	buffers = value

func get_create_animations() -> bool:
	return create_animations

func set_create_animations(value: bool) -> void:
	create_animations = value

func get_glb_data() -> PackedByteArray:
	return glb_data

func set_glb_data(value: PackedByteArray) -> void:
	glb_data = value

func get_json() -> Dictionary:
	return json

func set_json(value: Dictionary) -> void:
	json = value

func get_major_version() -> int:
	return major_version

func set_major_version(value: int) -> void:
	major_version = value

func get_minor_version() -> int:
	return minor_version

func set_minor_version(value: int) -> void:
	minor_version = value

func get_root_nodes() -> PackedInt32Array:
	return root_nodes

func set_root_nodes(value: PackedInt32Array) -> void:
	root_nodes = value

func get_scene_name() -> String:
	return scene_name

func set_scene_name(value: String) -> void:
	scene_name = value

func get_use_named_skin_binds() -> bool:
	return use_named_skin_binds

func set_use_named_skin_binds(value: bool) -> void:
	use_named_skin_binds = value

