extends Resource
class_name GLTFNode

## GLTF node class.
##
## Represents a GLTF node. GLTF nodes may have names, transforms, children (other GLTF nodes), and more specialized properties (represented by their own classes).
##
## @tutorial(GLTF scene and node spec): https://github.com/KhronosGroup/glTF-Tutorials/blob/master/gltfTutorial/gltfTutorial_004_ScenesNodes.md"



var camera: int:
	get = get_camera, set = set_camera

var children: PackedInt32Array:
	get = get_children, set = set_children

var height: int:
	get = get_height, set = set_height

var light: int:
	get = get_light, set = set_light

var mesh: int:
	get = get_mesh, set = set_mesh

var parent: int:
	get = get_parent, set = set_parent

var position: Vector3:
	get = get_position, set = set_position

var rotation: Quaternion:
	get = get_rotation, set = set_rotation

var scale: Vector3:
	get = get_scale, set = set_scale

var skeleton: int:
	get = get_skeleton, set = set_skeleton

var skin: int:
	get = get_skin, set = set_skin

var xform: Transform3D:
	get = get_xform, set = set_xform



## Gets additional arbitrary data in this [GLTFNode] instance. This can be used to keep per-node state data in [GLTFDocumentExtension] classes, which is important because they are stateless.
## The argument should be the [GLTFDocumentExtension] name (does not have to match the extension name in the GLTF file), and the return value can be anything you set. If nothing was set, the return value is null.
func get_additional_data(extension_name: StringName) -> Variant:
	pass;

## Sets additional arbitrary data in this [GLTFNode] instance. This can be used to keep per-node state data in [GLTFDocumentExtension] classes, which is important because they are stateless.
## The first argument should be the [GLTFDocumentExtension] name (does not have to match the extension name in the GLTF file), and the second argument can be anything you want.
func set_additional_data(extension_name: StringName, additional_data: Variant) -> void:
	pass;


func get_camera() -> int:
	return camera

func set_camera(value: int) -> void:
	camera = value

func get_children() -> PackedInt32Array:
	return children

func set_children(value: PackedInt32Array) -> void:
	children = value

func get_height() -> int:
	return height

func set_height(value: int) -> void:
	height = value

func get_light() -> int:
	return light

func set_light(value: int) -> void:
	light = value

func get_mesh() -> int:
	return mesh

func set_mesh(value: int) -> void:
	mesh = value

func get_parent() -> int:
	return parent

func set_parent(value: int) -> void:
	parent = value

func get_position() -> Vector3:
	return position

func set_position(value: Vector3) -> void:
	position = value

func get_rotation() -> Quaternion:
	return rotation

func set_rotation(value: Quaternion) -> void:
	rotation = value

func get_scale() -> Vector3:
	return scale

func set_scale(value: Vector3) -> void:
	scale = value

func get_skeleton() -> int:
	return skeleton

func set_skeleton(value: int) -> void:
	skeleton = value

func get_skin() -> int:
	return skin

func set_skin(value: int) -> void:
	skin = value

func get_xform() -> Transform3D:
	return xform

func set_xform(value: Transform3D) -> void:
	xform = value

