extends TextureLayered
class_name CompressedTextureLayered

## Base class for texture arrays that can optionally be compressed.
##
## A texture array that is loaded from a [code].ctexarray[/code] file. This file format is internal to Godot; it is created by importing other image formats with the import system. [CompressedTexture2D] can use one of 4 compresson methods:
## - Uncompressed (uncompressed on the GPU)
## - Lossless (WebP or PNG, uncompressed on the GPU)
## - Lossy (WebP, uncompressed on the GPU)
## - VRAM Compressed (compressed on the GPU)
## Only [b]VRAM Compressed[/b] actually reduces the memory usage on the GPU. The [b]Lossless[/b] and [b]Lossy[/b] compression methods will reduce the required storage on disk, but they will not reduce memory usage on the GPU as the texture is sent to the GPU uncompressed.
## Using [b]VRAM Compressed[/b] also improves loading times, as VRAM-compressed textures are faster to load compared to textures using lossless or lossy compression. VRAM compression can exhibit noticeable artifacts and is intended to be used for 3D rendering, not 2D.



## The path the texture should be loaded from.
var load_path: String:
	get = get_load_path, set = load



## Loads the texture at [param path].
func load(path: String) -> int:
	pass;


func get_load_path() -> String:
	return load_path

func load(value: String) -> void:
	load_path = value

