extends AnimationNodeSync
class_name AnimationNodeAdd3

## Blends two of three animations additively inside of an [AnimationNodeBlendTree].
##
## A resource to add to an [AnimationNodeBlendTree]. Blends two animations together additively out of three based on a value in the [code][-1.0, 1.0][/code] range.
## This node has three inputs:
## - The base animation to add to
## - A -add animation to blend with when the blend amount is in the [code][-1.0, 0.0][/code] range.
## - A +add animation to blend with when the blend amount is in the [code][0.0, 1.0][/code] range
##
## @tutorial(AnimationTree): https://docs.godotengine.org/en/stable/tutorials/animation/animation_tree.html
## @tutorial(Third Person Shooter Demo): https://godotengine.org/asset-library/asset/678






