extends RefCounted
class_name EditorScript

## Base script that can be used to add extension functions to the editor.
##
## Scripts extending this class and implementing its [method _run] method can be executed from the Script Editor's [b]File > Run[/b] menu option (or by pressing [kbd]Ctrl + Shift + X[/kbd]) while the editor is running. This is useful for adding custom in-editor functionality to Godot. For more complex additions, consider using [EditorPlugin]s instead.
## [b]Note:[/b] Extending scripts need to have [code]tool[/code] mode enabled.
## [b]Example script:[/b]
## [codeblocks]
## [gdscript]
## @tool
## extends EditorScript
## func _run():
## print("Hello from the Godot Editor!")
## [/gdscript]
## [csharp]
## using Godot;
## [Tool]
## public partial class HelloEditor : EditorScript
## {
## public override void _Run()
## {
## GD.Print("Hello from the Godot Editor!");
## }
## }
## [/csharp]
## [/codeblocks]
## [b]Note:[/b] The script is run in the Editor context, which means the output is visible in the console window started with the Editor (stdout) instead of the usual Godot [b]Output[/b] dock.
## [b]Note:[/b] EditorScript is [RefCounted], meaning it is destroyed when nothing references it. This can cause errors during asynchronous operations if there are no references to the script.





## This method is executed by the Editor when [b]File > Run[/b] is used.
func _run() -> void:
	pass;

## Adds [param node] as a child of the root node in the editor context.
## [b]Warning:[/b] The implementation of this method is currently disabled.
func add_root_node(node: Node) -> void:
	pass;

## Returns the [EditorInterface] singleton instance.
func get_editor_interface() -> EditorInterface:
	pass;

## Returns the Editor's currently active scene.
func get_scene() -> Node:
	pass;


