extends RefCounted
class_name EditorResourcePreviewGenerator

## Custom generator of previews.
##
## Custom code to generate previews. Please check [code]file_dialog/thumbnail_size[/code] in [EditorSettings] to find out the right size to do previews at.





## If this function returns [code]true[/code], the generator will call [method _generate] or [method _generate_from_path] for small previews as well.
## By default, it returns [code]false[/code].
func _can_generate_small_preview() -> bool:
	pass;

## Generate a preview from a given resource with the specified size. This must always be implemented.
## Returning an empty texture is an OK way to fail and let another generator take care.
## Care must be taken because this function is always called from a thread (not the main thread).
func _generate(resource: Resource, size: Vector2i) -> Texture2D:
	pass;

## Generate a preview directly from a path with the specified size. Implementing this is optional, as default code will load and call [method _generate].
## Returning an empty texture is an OK way to fail and let another generator take care.
## Care must be taken because this function is always called from a thread (not the main thread).
func _generate_from_path(path: String, size: Vector2i) -> Texture2D:
	pass;

## If this function returns [code]true[/code], the generator will automatically generate the small previews from the normal preview texture generated by the methods [method _generate] or [method _generate_from_path].
## By default, it returns [code]false[/code].
func _generate_small_preview_automatically() -> bool:
	pass;

## Returns [code]true[/code] if your generator supports the resource of type [param type].
func _handles(type: String) -> bool:
	pass;


