extends RefCounted
class_name XMLParser

## Low-level class for creating parsers for [url=https://en.wikipedia.org/wiki/XML]XML[/url] files.
##
## This class can serve as base to make custom XML parsers. Since XML is a very flexible standard, this interface is low-level so it can be applied to any possible schema.


## There's no node (no file or buffer opened).
## Element (tag).
## End of element.
## Text node.
## Comment node.
## CDATA content.
## Unknown node.

#enum NodeType
enum {
    NODE_NONE = 0,
    NODE_ELEMENT = 1,
    NODE_ELEMENT_END = 2,
    NODE_TEXT = 3,
    NODE_COMMENT = 4,
    NODE_CDATA = 5,
    NODE_UNKNOWN = 6,
}


## Gets the number of attributes in the current element.
func get_attribute_count() -> int:
	pass;

## Gets the name of the attribute specified by the [param idx] index.
func get_attribute_name(idx: int) -> String:
	pass;

## Gets the value of the attribute specified by the [param idx] index.
func get_attribute_value(idx: int) -> String:
	pass;

## Gets the current line in the parsed file, counting from 0.
func get_current_line() -> int:
	pass;

## Gets the value of a certain attribute of the current element by [param name]. This will raise an error if the element has no such attribute.
func get_named_attribute_value(name: String) -> String:
	pass;

## Gets the value of a certain attribute of the current element by [param name]. This will return an empty [String] if the attribute is not found.
func get_named_attribute_value_safe(name: String) -> String:
	pass;

## Gets the contents of a text node. This will raise an error in any other type of node.
func get_node_data() -> String:
	pass;

## Gets the name of the current element node. This will raise an error if the current node type is neither [constant NODE_ELEMENT] nor [constant NODE_ELEMENT_END].
func get_node_name() -> String:
	pass;

## Gets the byte offset of the current node since the beginning of the file or buffer.
func get_node_offset() -> int:
	pass;

## Gets the type of the current node. Compare with [enum NodeType] constants.
func get_node_type() -> int:
	pass;

## Check whether the current element has a certain attribute.
func has_attribute(name: String) -> bool:
	pass;

## Check whether the current element is empty (this only works for completely empty tags, e.g. [code]<element \>[/code]).
func is_empty() -> bool:
	pass;

## Opens an XML [param file] for parsing. This returns an error code.
func open(file: String) -> int:
	pass;

## Opens an XML raw [param buffer] for parsing. This returns an error code.
func open_buffer(buffer: PackedByteArray) -> int:
	pass;

## Reads the next node of the file. This returns an error code.
func read() -> int:
	pass;

## Moves the buffer cursor to a certain offset (since the beginning) and read the next node there. This returns an error code.
func seek(position: int) -> int:
	pass;

## Skips the current section. If the node contains other elements, they will be ignored and the cursor will go to the closing of the current element.
func skip_section() -> void:
	pass;


