extends Control
class_name TabBar

## Tab bar control.
##
## Simple tabs control, similar to [TabContainer] but is only in charge of drawing tabs, not interacting with children.


## Emitted when the active tab is rearranged via mouse drag. See [member drag_to_rearrange_enabled].
signal active_tab_rearranged(idx_to: int)
## Emitted when a tab's right button is pressed. See [method set_tab_button_icon].
signal tab_button_pressed(tab: int)
## Emitted when switching to another tab.
signal tab_changed(tab: int)
## Emitted when a tab is clicked, even if it is the current tab.
signal tab_clicked(tab: int)
## Emitted when a tab's close button is pressed.
## [b]Note:[/b] Tabs are not removed automatically once the close button is pressed, this behavior needs to be programmed manually. For example:
## [codeblocks]
## [gdscript]
## $TabBar.tab_close_pressed.connect($TabBar.remove_tab)
## [/gdscript]
## [csharp]
## GetNode<TabBar>("TabBar").TabClosePressed += GetNode<TabBar>("TabBar").RemoveTab;
## [/csharp]
## [/codeblocks]
signal tab_close_pressed(tab: int)
## Emitted when a tab is hovered by the mouse.
signal tab_hovered(tab: int)
## Emitted when a tab is right-clicked. [member select_with_rmb] must be enabled.
signal tab_rmb_clicked(tab: int)
## Emitted when a tab is selected via click or script, even if it is the current tab.
signal tab_selected(tab: int)
## Places tabs to the left.
## Places tabs in the middle.
## Places tabs to the right.
## Represents the size of the [enum AlignmentMode] enum.
## Never show the close buttons.
## Only show the close button on the currently active tab.
## Show the close button on all tabs.
## Represents the size of the [enum CloseButtonDisplayPolicy] enum.

#enum AlignmentMode
enum {
    ALIGNMENT_LEFT = 0,
    ALIGNMENT_CENTER = 1,
    ALIGNMENT_RIGHT = 2,
    ALIGNMENT_MAX = 3,
}
#enum CloseButtonDisplayPolicy
enum {
    CLOSE_BUTTON_SHOW_NEVER = 0,
    CLOSE_BUTTON_SHOW_ACTIVE_ONLY = 1,
    CLOSE_BUTTON_SHOW_ALWAYS = 2,
    CLOSE_BUTTON_MAX = 3,
}
## If [code]true[/code], tabs overflowing this node's width will be hidden, displaying two navigation buttons instead. Otherwise, this node's minimum size is updated so that all tabs are visible.
var clip_tabs: bool:
	get = get_clip_tabs, set = set_clip_tabs

## Select tab at index [code]tab_idx[/code].
var current_tab: int:
	get = get_current_tab, set = set_current_tab

## If [code]true[/code], tabs can be rearranged with mouse drag.
var drag_to_rearrange_enabled: bool:
	get = get_drag_to_rearrange_enabled, set = set_drag_to_rearrange_enabled

## Sets the maximum width which all tabs should be limited to. Unlimited if set to [code]0[/code].
var max_tab_width: int:
	get = get_max_tab_width, set = set_max_tab_width

## If [code]true[/code], the tab offset will be changed to keep the currently selected tab visible.
var scroll_to_selected: bool:
	get = get_scroll_to_selected, set = set_scroll_to_selected

## if [code]true[/code], the mouse's scroll wheel can be used to navigate the scroll view.
var scrolling_enabled: bool:
	get = get_scrolling_enabled, set = set_scrolling_enabled

## If [code]true[/code], enables selecting a tab with the right mouse button.
var select_with_rmb: bool:
	get = get_select_with_rmb, set = set_select_with_rmb

## Sets the position at which tabs will be placed. See [enum AlignmentMode] for details.
var tab_alignment: int:
	get = get_tab_alignment, set = set_tab_alignment

## Sets when the close button will appear on the tabs. See [enum CloseButtonDisplayPolicy] for details.
var tab_close_display_policy: int:
	get = get_tab_close_display_policy, set = set_tab_close_display_policy

## The number of tabs currently in the bar.
var tab_count: int:
	get = get_tab_count, set = set_tab_count

## [TabBar]s with the same rearrange group ID will allow dragging the tabs between them. Enable drag with [member drag_to_rearrange_enabled].
## Setting this to [code]-1[/code] will disable rearranging between [TabBar]s.
var tabs_rearrange_group: int:
	get = get_tabs_rearrange_group, set = set_tabs_rearrange_group



## Adds a new tab.
func add_tab(title: String = "", icon: Texture2D = null) -> void:
	pass;

## Clears all tabs.
func clear_tabs() -> void:
	pass;

## Moves the scroll view to make the tab visible.
func ensure_tab_visible(idx: int) -> void:
	pass;

## Returns [code]true[/code] if the offset buttons (the ones that appear when there's not enough space for all tabs) are visible.
func get_offset_buttons_visible() -> bool:
	pass;

## Returns the previously active tab index.
func get_previous_tab() -> int:
	pass;

## Returns the [Texture2D] for the right button of the tab at index [param tab_idx] or [code]null[/code] if the button has no [Texture2D].
func get_tab_button_icon(tab_idx: int) -> Texture2D:
	pass;

## Returns the [Texture2D] for the tab at index [param tab_idx] or [code]null[/code] if the tab has no [Texture2D].
func get_tab_icon(tab_idx: int) -> Texture2D:
	pass;

## Returns the index of the tab at local coordinates [param point]. Returns [code]-1[/code] if the point is outside the control boundaries or if there's no tab at the queried position.
func get_tab_idx_at_point(point: Vector2) -> int:
	pass;

## Returns tab title language code.
func get_tab_language(tab_idx: int) -> String:
	pass;

## Returns the number of hidden tabs offsetted to the left.
func get_tab_offset() -> int:
	pass;

## Returns tab [Rect2] with local position and size.
func get_tab_rect(tab_idx: int) -> Rect2:
	pass;

## Returns tab title text base writing direction.
func get_tab_text_direction(tab_idx: int) -> int:
	pass;

## Returns the title of the tab at index [param tab_idx].
func get_tab_title(tab_idx: int) -> String:
	pass;

## Returns [code]true[/code] if the tab at index [param tab_idx] is disabled.
func is_tab_disabled(tab_idx: int) -> bool:
	pass;

## Returns [code]true[/code] if the tab at index [param tab_idx] is hidden.
func is_tab_hidden(tab_idx: int) -> bool:
	pass;

## Moves a tab from [param from] to [param to].
func move_tab(from: int, to: int) -> void:
	pass;

## Removes the tab at index [param tab_idx].
func remove_tab(tab_idx: int) -> void:
	pass;

## Sets an [param icon] for the button of the tab at index [param tab_idx] (located to the right, before the close button), making it visible and clickable (See [signal tab_button_pressed]). Giving it a [code]null[/code] value will hide the button.
func set_tab_button_icon(tab_idx: int, icon: Texture2D) -> void:
	pass;

## If [param disabled] is [code]true[/code], disables the tab at index [param tab_idx], making it non-interactable.
func set_tab_disabled(tab_idx: int, disabled: bool) -> void:
	pass;

## If [param hidden] is [code]true[/code], hides the tab at index [param tab_idx], making it disappear from the tab area.
func set_tab_hidden(tab_idx: int, hidden: bool) -> void:
	pass;

## Sets an [param icon] for the tab at index [param tab_idx].
func set_tab_icon(tab_idx: int, icon: Texture2D) -> void:
	pass;

## Sets language code of tab title used for line-breaking and text shaping algorithms, if left empty current locale is used instead.
func set_tab_language(tab_idx: int, language: String) -> void:
	pass;

## Sets tab title base writing direction.
func set_tab_text_direction(tab_idx: int, direction: int) -> void:
	pass;

## Sets a [param title] for the tab at index [param tab_idx].
func set_tab_title(tab_idx: int, title: String) -> void:
	pass;


func get_clip_tabs() -> bool:
	return clip_tabs

func set_clip_tabs(value: bool) -> void:
	clip_tabs = value

func get_current_tab() -> int:
	return current_tab

func set_current_tab(value: int) -> void:
	current_tab = value

func get_drag_to_rearrange_enabled() -> bool:
	return drag_to_rearrange_enabled

func set_drag_to_rearrange_enabled(value: bool) -> void:
	drag_to_rearrange_enabled = value

func get_max_tab_width() -> int:
	return max_tab_width

func set_max_tab_width(value: int) -> void:
	max_tab_width = value

func get_scroll_to_selected() -> bool:
	return scroll_to_selected

func set_scroll_to_selected(value: bool) -> void:
	scroll_to_selected = value

func get_scrolling_enabled() -> bool:
	return scrolling_enabled

func set_scrolling_enabled(value: bool) -> void:
	scrolling_enabled = value

func get_select_with_rmb() -> bool:
	return select_with_rmb

func set_select_with_rmb(value: bool) -> void:
	select_with_rmb = value

func get_tab_alignment() -> int:
	return tab_alignment

func set_tab_alignment(value: int) -> void:
	tab_alignment = value

func get_tab_close_display_policy() -> int:
	return tab_close_display_policy

func set_tab_close_display_policy(value: int) -> void:
	tab_close_display_policy = value

func get_tab_count() -> int:
	return tab_count

func set_tab_count(value: int) -> void:
	tab_count = value

func get_tabs_rearrange_group() -> int:
	return tabs_rearrange_group

func set_tabs_rearrange_group(value: int) -> void:
	tabs_rearrange_group = value

