extends Resource
class_name SyntaxHighlighter

## Base Syntax highlighter resource for [TextEdit].
##
## Base syntax highlighter resource all syntax highlighters extend from, provides syntax highlighting data to [TextEdit].
## The associated [TextEdit] node will call into the [SyntaxHighlighter] on an as-needed basis.
## [b]Note:[/b] Each Syntax highlighter instance should not be shared across multiple [TextEdit] nodes.





## Virtual method which can be overridden to clear any local caches.
func _clear_highlighting_cache() -> void:
	pass;

## Virtual method which can be overridden to return syntax highlighting data.
## See [method get_line_syntax_highlighting] for more details.
func _get_line_syntax_highlighting(line: int) -> Dictionary:
	pass;

## Virtual method which can be overridden to update any local caches.
func _update_cache() -> void:
	pass;

## Clears all cached syntax highlighting data.
## Then calls overridable method [method _clear_highlighting_cache].
func clear_highlighting_cache() -> void:
	pass;

## Returns syntax highlighting data for a single line. If the line is not cached, calls [method _get_line_syntax_highlighting] to calculate the data.
## The return [Dictionary] is column number to [Dictionary]. The column number notes the start of a region, the region will end if another region is found, or at the end of the line. The nested [Dictionary] contains the data for that region, currently only the key "color" is supported.
## [b]Example return:[/b]
## [codeblock]
## var color_map = {
## 0: {
## "color": Color(1, 0, 0)
## },
## 5: {
## "color": Color(0, 1, 0)
## }
## }
## [/codeblock]
## This will color columns 0-4 red, and columns 5-eol in green.
func get_line_syntax_highlighting(line: int) -> Dictionary:
	pass;

## Returns the associated [TextEdit] node.
func get_text_edit() -> TextEdit:
	pass;

## Clears then updates the [SyntaxHighlighter] caches. Override [method _update_cache] for a callback.
## [b]Note:[/b] This is called automatically when the associated [TextEdit] node, updates its own cache.
func update_cache() -> void:
	pass;


