extends Occluder3D
class_name QuadOccluder3D

## Flat plane shape for use with occlusion culling in [OccluderInstance3D].
##
## [QuadOccluder3D] stores a flat plane shape that can be used by the engine's occlusion culling system. See also [PolygonOccluder3D] if you need to customize the quad's shape.
## See [OccluderInstance3D]'s documentation for instructions on setting up occlusion culling.



## The quad's size in 3D units.
var size: Vector2:
	get = get_size, set = set_size




func get_size() -> Vector2:
	return size

func set_size(value: Vector2) -> void:
	size = value

