extends RefCounted
class_name EngineProfiler

## Base class for creating custom profilers.
##
## This class can be used to implement custom profilers that are able to interact with the engine and editor debugger.
## See [EngineDebugger] and [EditorDebuggerPlugin] for more information.





## Called when data is added to profiler using [method EngineDebugger.profiler_add_frame_data].
func _add_frame(data: Array) -> void:
	pass;

## Called once every engine iteration when the profiler is active with information about the current frame. All time values are in seconds. Lower values represent faster processing times and are therefore considered better.
func _tick(frame_time: float, process_time: float, physics_time: float, physics_frame_time: float) -> void:
	pass;

## Called when the profiler is enabled/disabled, along with a set of [param options].
func _toggle(enable: bool, options: Array) -> void:
	pass;


