extends StaticBody2D
class_name AnimatableBody2D

## Physics body for 2D physics which moves only by script or animation (while affecting other bodies on its path). Useful for moving platforms and doors.
##
## Animatable body for 2D physics.
## An animatable body can't be moved by external forces or contacts, but can be moved by script or animation to affect other bodies in its path. It is ideal for implementing moving objects in the environment, such as moving platforms or doors.
## When the body is moved manually, either from code or from an [AnimationPlayer] (with [member AnimationPlayer.playback_process_mode] set to [code]physics[/code]), the physics will automatically compute an estimate of their linear and angular velocity. This makes them very useful for moving platforms or other AnimationPlayer-controlled objects (like a door, a bridge that opens, etc).



## If [code]true[/code], the body's movement will be synchronized to the physics frame. This is useful when animating movement via [AnimationPlayer], for example on moving platforms. Do [b]not[/b] use together with [method PhysicsBody2D.move_and_collide].
var sync_to_physics: bool:
	get = is_sync_to_physics_enabled, set = set_sync_to_physics




func is_sync_to_physics_enabled() -> bool:
	return sync_to_physics

func set_sync_to_physics(value: bool) -> void:
	sync_to_physics = value

