extends RefCounted
class_name ZIPPacker

## Allows the creation of zip files.
##
## This class implements a writer that allows storing the multiple blobs in a zip archive.
## [codeblock]
## func write_zip_file():
## var writer := ZIPPacker.new()
## var err := writer.open("user://archive.zip")
## if err != OK:
## return err
## writer.start_file("hello.txt")
## writer.write_file("Hello World".to_utf8_buffer())
## writer.close_file()
## writer.close()
## return OK
## [/codeblock]



#enum ZipAppend
enum {
    APPEND_CREATE = 0,
    APPEND_CREATEAFTER = 1,
    APPEND_ADDINZIP = 2,
}


## Closes the underlying resources used by this instance.
func close() -> int:
	pass;

## Stops writing to a file within the archive.
## It will fail if there is no open file.
func close_file() -> int:
	pass;

## Opens a zip file for writing at the given path using the specified write mode.
## This must be called before everything else.
func open(path: String, append: int = 0) -> int:
	pass;

## Starts writing to a file within the archive. Only one file can be written at the same time.
## Must be called after [method open].
func start_file(path: String) -> int:
	pass;

## Write the given [param data] to the file.
## Needs to be called after [method start_file].
func write_file(data: PackedByteArray) -> int:
	pass;


