extends VisualShaderNodeConstant
class_name VisualShaderNodeColorConstant

## A [Color] constant to be used within the visual shader graph.
##
## Has two output ports representing RGB and alpha channels of [Color].
## Translated to [code]vec3 rgb[/code] and [code]float alpha[/code] in the shader language.



## A [Color] constant which represents a state of this node.
var constant: Color:
	get = get_constant, set = set_constant




func get_constant() -> Color:
	return constant

func set_constant(value: Color) -> void:
	constant = value

