extends Container
class_name MarginContainer

## Simple margin container.
##
## Adds a top, left, bottom, and right margin to all [Control] nodes that are direct children of the container. To control the [MarginContainer]'s margin, use the [code]margin_*[/code] theme properties listed below.
## [b]Note:[/b] Be careful, [Control] margin values are different from the constant margin values. If you want to change the custom margin values of the [MarginContainer] by code, you should use the following examples:
## [codeblocks]
## [gdscript]
## # This code sample assumes the current script is extending MarginContainer.
## var margin_value = 100
## add_theme_constant_override("margin_top", margin_value)
## add_theme_constant_override("margin_left", margin_value)
## add_theme_constant_override("margin_bottom", margin_value)
## add_theme_constant_override("margin_right", margin_value)
## [/gdscript]
## [csharp]
## // This code sample assumes the current script is extending MarginContainer.
## int marginValue = 100;
## AddThemeConstantOverride("margin_top", marginValue);
## AddThemeConstantOverride("margin_left", marginValue);
## AddThemeConstantOverride("margin_bottom", marginValue);
## AddThemeConstantOverride("margin_right", marginValue);
## [/csharp]
## [/codeblocks]
##
## @tutorial(GUI containers): https://docs.godotengine.org/en/stable/tutorials/ui/gui_containers.html






