extends VBoxContainer
class_name FileSystemDock

## Editor dock for managing files in the project.
##
## This class is available only in [EditorPlugin]s and can't be instantiated. You can access it using [method EditorInterface.get_file_system_dock].
## While FileSystemDock doesn't expose any methods for file manipulation, you can listen for various file-related signals.


## Emitted when the user switches file display mode or split mode.
signal display_mode_changed
## Emitted when the given [param file] was removed.
signal file_removed(file: String)
## Emitted when a file is moved from [param old_file] path to [param new_file] path.
signal files_moved(old_file: String, new_file: String)
## Emitted when a folder is moved from [param old_folder] path to [param new_folder] path.
signal folder_moved(old_folder: String, new_folder: String)
## Emitted when the given [param folder] was removed.
signal folder_removed(folder: String)
## Emitted when a new scene is created that inherits the scene at [param file] path.
signal inherit(file: String)
## Emitted when the given scenes are being instantiated in the editor.
signal instantiate(files: PackedStringArray)
## Emitted when an external [param resource] had its file removed.
signal resource_removed(resource: Resource)



## Sets the given [param path] as currently selected, ensuring that the selected file/directory is visible.
func navigate_to_path(path: String) -> void:
	pass;


