extends Object
class_name EditorSelection

## Manages the SceneTree selection in the editor.
##
## This object manages the SceneTree selection in the editor.
## [b]Note:[/b] This class shouldn't be instantiated directly. Instead, access the singleton using [method EditorInterface.get_selection].


## Emitted when the selection changes.
signal selection_changed



## Adds a node to the selection.
## [b]Note:[/b] The newly selected node will not be automatically edited in the inspector. If you want to edit a node, use [method EditorInterface.edit_node].
func add_node(node: Node) -> void:
	pass;

## Clear the selection.
func clear() -> void:
	pass;

## Gets the list of selected nodes.
func get_selected_nodes() -> Array[Node]:
	pass;

## Gets the list of selected nodes, optimized for transform operations (i.e. moving them, rotating, etc). This list avoids situations where a node is selected and also child/grandchild.
func get_transformable_selected_nodes() -> Array[Node]:
	pass;

## Removes a node from the selection.
func remove_node(node: Node) -> void:
	pass;


