class_name int

## Integer built-in type.
##
## Signed 64-bit integer type.
## It can take values in the interval [code][-2^63, 2^63 - 1][/code], i.e. [code][-9223372036854775808, 9223372036854775807][/code]. Exceeding those bounds will wrap around.
## [int] is a [Variant] type, and will thus be used when assigning an integer value to a [Variant]. It can also be enforced with the [code]: int[/code] type hint.
## [codeblocks]
## [gdscript]
## var my_variant = 0 # int, value 0.
## my_variant += 4.2 # float, value 4.2.
## var my_int: int = 1 # int, value 1.
## my_int = 4.2 # int, value 4, the right value is implicitly cast to int.
## my_int = int("6.7") # int, value 6, the String is explicitly cast with int.
## var max_int = 9223372036854775807
## print(max_int) # 9223372036854775807, OK.
## max_int += 1
## print(max_int) # -9223372036854775808, we overflowed and wrapped around.
## [/gdscript]
## [csharp]
## int myInt = (int)"6.7".ToFloat(); // int, value 6, the String is explicitly cast with int.
## // We have to use `long` here, because GDSript's `int`
## // is 64 bits long while C#'s `int` is only 32 bits.
## long maxInt = 9223372036854775807;
## GD.Print(maxInt); // 9223372036854775807, OK.
## maxInt++;
## GD.Print(maxInt); // -9223372036854775808, we overflowed and wrapped around.
## // Alternatively, if we used C#'s 32-bit `int` type, the maximum value is much smaller:
## int halfInt = 2147483647;
## GD.Print(halfInt); // 2147483647, OK.
## halfInt++;
## GD.Print(halfInt); // -2147483648, we overflowed and wrapped around.
## [/csharp]
## [/codeblocks]




## Constructs a default-initialized [int] set to [code]0[/code].
func int() -> int:
	pass;

## Constructs an [int] as a copy of the given [int].
func int(from: int) -> int:
	pass;

## Converts a [String] to an [int], following the same rules as [method String.to_int].
func int(from: String) -> int:
	pass;

## Cast a [bool] value to an integer value, [code]int(true)[/code] will be equals to 1 and [code]int(false)[/code] will be equals to 0.
func int(from: bool) -> int:
	pass;

## Cast a float value to an integer value, this method simply removes the number fractions (i.e. rounds [param from] towards zero), so for example [code]int(2.7)[/code] will be equals to 2, [code]int(0.1)[/code] will be equals to 0 and [code]int(-2.7)[/code] will be equals to -2. This operation is also called truncation.
func int(from: float) -> int:
	pass;



