extends VisualShaderNodeGroupBase
class_name VisualShaderNodeExpression

## A custom visual shader graph expression written in Godot Shading Language.
##
## Custom Godot Shading Language expression, with a custom number of input and output ports.
## The provided code is directly injected into the graph's matching shader function ([code]vertex[/code], [code]fragment[/code], or [code]light[/code]), so it cannot be used to declare functions, varyings, uniforms, or global constants. See [VisualShaderNodeGlobalExpression] for such global definitions.



## An expression in Godot Shading Language, which will be injected at the start of the graph's matching shader function ([code]vertex[/code], [code]fragment[/code], or [code]light[/code]), and thus cannot be used to declare functions, varyings, uniforms, or global constants.
var expression: String:
	get = get_expression, set = set_expression




func get_expression() -> String:
	return expression

func set_expression(value: String) -> void:
	expression = value

