extends Object
class_name TextServerManager

## Manager for the font and complex text layout servers.
##
## [TextServerManager] is the API backend for loading, enumeration and switching [TextServer]s.
## [b]Note:[/b] Switching text server at runtime is possible, but will invalidate all fonts and text buffers. Make sure to unload all controls, fonts, and themes before doing so.


## Emitted when a new interface has been added.
signal interface_added(interface_name: StringName)
## Emitted when an interface is removed.
signal interface_removed(interface_name: StringName)



## Registers an [TextServer] interface.
func add_interface(interface: TextServer) -> void:
	pass;

## Finds an interface by its name.
func find_interface(name: String) -> TextServer:
	pass;

## Returns the interface registered at a given index.
func get_interface(idx: int) -> TextServer:
	pass;

## Returns the number of interfaces currently registered.
func get_interface_count() -> int:
	pass;

## Returns a list of available interfaces the index and name of each interface.
func get_interfaces() -> Array[Dictionary]:
	pass;

## Returns the primary [TextServer] interface currently in use.
func get_primary_interface() -> TextServer:
	pass;

## Removes interface. All fonts and shaped text caches should be freed before removing interface.
func remove_interface(interface: TextServer) -> void:
	pass;

## Sets the primary [TextServer] interface.
func set_primary_interface(index: TextServer) -> void:
	pass;


