extends PrimitiveMesh
class_name SphereMesh

## Class representing a spherical [PrimitiveMesh].
##
## Class representing a spherical [PrimitiveMesh].



## Full height of the sphere.
var height: float:
	get = get_height, set = set_height

## If [code]true[/code], a hemisphere is created rather than a full sphere.
## [b]Note:[/b] To get a regular hemisphere, the height and radius of the sphere must be equal.
var is_hemisphere: bool:
	get = get_is_hemisphere, set = set_is_hemisphere

## Number of radial segments on the sphere.
var radial_segments: int:
	get = get_radial_segments, set = set_radial_segments

## Radius of sphere.
var radius: float:
	get = get_radius, set = set_radius

## Number of segments along the height of the sphere.
var rings: int:
	get = get_rings, set = set_rings




func get_height() -> float:
	return height

func set_height(value: float) -> void:
	height = value

func get_is_hemisphere() -> bool:
	return is_hemisphere

func set_is_hemisphere(value: bool) -> void:
	is_hemisphere = value

func get_radial_segments() -> int:
	return radial_segments

func set_radial_segments(value: int) -> void:
	radial_segments = value

func get_radius() -> float:
	return radius

func set_radius(value: float) -> void:
	radius = value

func get_rings() -> int:
	return rings

func set_rings(value: int) -> void:
	rings = value

