extends ConfirmationDialog
class_name ScriptCreateDialog

## The Editor's popup dialog for creating new [Script] files.
##
## The [ScriptCreateDialog] creates script files according to a given template for a given scripting language. The standard use is to configure its fields prior to calling one of the [method Window.popup] methods.
## [codeblocks]
## [gdscript]
## func _ready():
## var dialog = ScriptCreateDialog.new();
## dialog.config("Node", "res://new_node.gd") # For in-engine types.
## dialog.config("\"res://base_node.gd\"", "res://derived_node.gd") # For script types.
## dialog.popup_centered()
## [/gdscript]
## [csharp]
## public override void _Ready()
## {
## var dialog = new ScriptCreateDialog();
## dialog.Config("Node", "res://NewNode.cs"); // For in-engine types.
## dialog.Config("\"res://BaseNode.cs\"", "res://DerivedNode.cs"); // For script types.
## dialog.PopupCentered();
## }
## [/csharp]
## [/codeblocks]


## Emitted when the user clicks the OK button.
signal script_created(script: Script)

var dialog_hide_on_ok: bool:
	get = get_hide_on_ok, set = set_hide_on_ok

var ok_button_text: String:
	get = get_ok_button_text, set = set_ok_button_text

var title: String:
	get = get_title, set = set_title



## Prefills required fields to configure the ScriptCreateDialog for use.
func config(inherits: String, path: String, built_in_enabled: bool = true, load_enabled: bool = true) -> void:
	pass;


func get_hide_on_ok() -> bool:
	return dialog_hide_on_ok

func set_hide_on_ok(value: bool) -> void:
	dialog_hide_on_ok = value

func get_ok_button_text() -> String:
	return ok_button_text

func set_ok_button_text(value: String) -> void:
	ok_button_text = value

func get_title() -> String:
	return title

func set_title(value: String) -> void:
	title = value

