extends Object
class_name JSONRPC

## A helper to handle dictionaries which look like JSONRPC documents.
##
## [url=https://www.jsonrpc.org/]JSON-RPC[/url] is a standard which wraps a method call in a [JSON] object. The object has a particular structure and identifies which method is called, the parameters to that function, and carries an ID to keep track of responses. This class implements that standard on top of [Dictionary]; you will have to convert between a [Dictionary] and [JSON] with other functions.


## A method call was requested but no function of that name existed in the JSONRPC subclass.

#enum ErrorCode
enum {
    PARSE_ERROR = -32700,
    INVALID_REQUEST = -32600,
    METHOD_NOT_FOUND = -32601,
    INVALID_PARAMS = -32602,
    INTERNAL_ERROR = -32603,
}


## Returns a dictionary in the form of a JSON-RPC notification. Notifications are one-shot messages which do not expect a response.
## - [param method]: Name of the method being called.
## - [param params]: An array or dictionary of parameters being passed to the method.
func make_notification(method: String, params: Variant) -> Dictionary:
	pass;

## Returns a dictionary in the form of a JSON-RPC request. Requests are sent to a server with the expectation of a response. The ID field is used for the server to specify which exact request it is responding to.
## - [param method]: Name of the method being called.
## - [param params]: An array or dictionary of parameters being passed to the method.
## - [param id]: Uniquely identifies this request. The server is expected to send a response with the same ID.
func make_request(method: String, params: Variant, id: Variant) -> Dictionary:
	pass;

## When a server has received and processed a request, it is expected to send a response. If you did not want a response then you need to have sent a Notification instead.
## - [param result]: The return value of the function which was called.
## - [param id]: The ID of the request this response is targeted to.
func make_response(result: Variant, id: Variant) -> Dictionary:
	pass;

## Creates a response which indicates a previous reply has failed in some way.
## - [param code]: The error code corresponding to what kind of error this is. See the [enum ErrorCode] constants.
## - [param message]: A custom message about this error.
## - [param id]: The request this error is a response to.
func make_response_error(code: int, message: String, id: Variant = null) -> Dictionary:
	pass;

## Given a Dictionary which takes the form of a JSON-RPC request: unpack the request and run it. Methods are resolved by looking at the field called "method" and looking for an equivalently named function in the JSONRPC object. If one is found that method is called.
## To add new supported methods extend the JSONRPC class and call [method process_action] on your subclass.
## [param action]: The action to be run, as a Dictionary in the form of a JSON-RPC request or notification.
func process_action(action: Variant, recurse: bool = false) -> Variant:
	pass;

func process_string(action: String) -> String:
	pass;

func set_scope(scope: String, target: Object) -> void:
	pass;


