extends GPUParticlesCollision3D
class_name GPUParticlesCollisionSphere3D

## Sphere-shaped 3D particle collision shape affecting [GPUParticles3D] nodes.
##
## Sphere-shaped 3D particle collision shape affecting [GPUParticles3D] nodes.
## [b]Note:[/b] [member ParticleProcessMaterial.collision_mode] must be [constant ParticleProcessMaterial.COLLISION_RIGID] or [constant ParticleProcessMaterial.COLLISION_HIDE_ON_CONTACT] on the [GPUParticles3D]'s process material for collision to work.
## [b]Note:[/b] Particle collision only affects [GPUParticles3D], not [CPUParticles3D].



## The collision sphere's radius in 3D units.
var radius: float:
	get = get_radius, set = set_radius




func get_radius() -> float:
	return radius

func set_radius(value: float) -> void:
	radius = value

