extends ImageTextureLayered
class_name CubemapArray

## A single composite texture resource which consists of multiple [Cubemap]s.
##
## [CubemapArray]s are made of an array of [Cubemap]s. Accordingly, like [Cubemap]s they are made of multiple textures the amount of which must be divisible by 6 (one image for each face of the cube). The primary benefit of [CubemapArray]s is that they can be accessed in shader code using a single texture reference. In other words, you can pass multiple [Cubemap]s into a shader using a single [CubemapArray].
## Generally, [CubemapArray]s provide a more efficient way for storing multiple [Cubemap]s compared to storing multiple [Cubemap]s themselves in an array.
## Internally, Godot uses [CubemapArray]s for many effects including the [Sky], if you set [member ProjectSettings.rendering/reflections/sky_reflections/texture_array_reflections] to [code]true[/code].
## To create such a texture file yourself, reimport your image files using the Godot Editor import presets.
## [b]Note:[/b] [CubemapArray] is not supported in the OpenGL 3 rendering backend.





## Creates a placeholder version of this resource ([PlaceholderCubemapArray]).
func create_placeholder() -> Resource:
	pass;


