extends Joint3D
class_name ConeTwistJoint3D

## A twist joint between two 3D PhysicsBodies.
##
## The joint can rotate the bodies across an axis defined by the local x-axes of the [Joint3D].
## The twist axis is initiated as the X axis of the [Joint3D].
## Once the Bodies swing, the twist axis is calculated as the middle of the x-axes of the Joint3D in the local space of the two Bodies. See also [Generic6DOFJoint3D].


## Swing is rotation from side to side, around the axis perpendicular to the twist axis.
## The swing span defines, how much rotation will not get corrected along the swing axis.
## Could be defined as looseness in the [ConeTwistJoint3D].
## If below 0.05, this behavior is locked.
## Twist is the rotation around the twist axis, this value defined how far the joint can twist.
## Twist is locked if below 0.05.
## The speed with which the swing or twist will take place.
## The higher, the faster.
## The ease with which the joint starts to twist. If it's too low, it takes more force to start twisting the joint.
## Defines, how fast the swing- and twist-speed-difference on both sides gets synced.
## Represents the size of the [enum Param] enum.

#enum Param
enum {
    PARAM_SWING_SPAN = 0,
    PARAM_TWIST_SPAN = 1,
    PARAM_BIAS = 2,
    PARAM_SOFTNESS = 3,
    PARAM_RELAXATION = 4,
    PARAM_MAX = 5,
}
## The speed with which the swing or twist will take place.
## The higher, the faster.
var bias: float:
	get = get_param, set = set_param

## Defines, how fast the swing- and twist-speed-difference on both sides gets synced.
var relaxation: float:
	get = get_param, set = set_param

## The ease with which the joint starts to twist. If it's too low, it takes more force to start twisting the joint.
var softness: float:
	get = get_param, set = set_param

## Swing is rotation from side to side, around the axis perpendicular to the twist axis.
## The swing span defines, how much rotation will not get corrected along the swing axis.
## Could be defined as looseness in the [ConeTwistJoint3D].
## If below 0.05, this behavior is locked.
var swing_span: float:
	get = get_param, set = set_param

## Twist is the rotation around the twist axis, this value defined how far the joint can twist.
## Twist is locked if below 0.05.
var twist_span: float:
	get = get_param, set = set_param



func get_param(param: int) -> float:
	pass;

func set_param(param: int, value: float) -> void:
	pass;


func get_param() -> float:
	return bias

func set_param(value: float) -> void:
	bias = value

func get_param() -> float:
	return relaxation

func set_param(value: float) -> void:
	relaxation = value

func get_param() -> float:
	return softness

func set_param(value: float) -> void:
	softness = value

func get_param() -> float:
	return swing_span

func set_param(value: float) -> void:
	swing_span = value

func get_param() -> float:
	return twist_span

func set_param(value: float) -> void:
	twist_span = value

