extends Node3D
class_name CollisionPolygon3D

## Editor-only node for defining a collision polygon in 3D space.
##
## Allows editing a concave or convex collision polygon's vertices on a selected plane. Can also set a depth perpendicular to that plane. This class is only available in the editor. It will not appear in the scene tree at run-time. Creates several [ConvexPolygonShape3D]s at run-time to represent the original polygon using convex decomposition.
## [b]Note:[/b] Since this is an editor-only helper, properties modified during gameplay will have no effect.
## [b]Warning:[/b] A non-uniformly scaled CollisionPolygon3D node will probably not function as expected. Please make sure to keep its scale uniform (i.e. the same on all axes), and change its [member polygon]'s vertices instead.



## Length that the resulting collision extends in either direction perpendicular to its polygon.
var depth: float:
	get = get_depth, set = set_depth

## If [code]true[/code], no collision will be produced.
var disabled: bool:
	get = is_disabled, set = set_disabled

## The collision margin for the generated [Shape3D]. See [member Shape3D.margin] for more details.
var margin: float:
	get = get_margin, set = set_margin

## Array of vertices which define the polygon.
## [b]Note:[/b] The returned value is a copy of the original. Methods which mutate the size or properties of the return value will not impact the original polygon. To change properties of the polygon, assign it to a temporary variable and make changes before reassigning the [code]polygon[/code] member.
var polygon: PackedVector2Array:
	get = get_polygon, set = set_polygon




func get_depth() -> float:
	return depth

func set_depth(value: float) -> void:
	depth = value

func is_disabled() -> bool:
	return disabled

func set_disabled(value: bool) -> void:
	disabled = value

func get_margin() -> float:
	return margin

func set_margin(value: float) -> void:
	margin = value

func get_polygon() -> PackedVector2Array:
	return polygon

func set_polygon(value: PackedVector2Array) -> void:
	polygon = value

