extends RefCounted
class_name AESContext

## Interface to low level AES encryption features.
##
## This class provides access to AES encryption/decryption of raw data. Both AES-ECB and AES-CBC mode are supported.
## [codeblocks]
## [gdscript]
## extends Node
## var aes = AESContext.new()
## func _ready():
## var key = "My secret key!!!" # Key must be either 16 or 32 bytes.
## var data = "My secret text!!" # Data size must be multiple of 16 bytes, apply padding if needed.
## # Encrypt ECB
## aes.start(AESContext.MODE_ECB_ENCRYPT, key.to_utf8())
## var encrypted = aes.update(data.to_utf8())
## aes.finish()
## # Decrypt ECB
## aes.start(AESContext.MODE_ECB_DECRYPT, key.to_utf8())
## var decrypted = aes.update(encrypted)
## aes.finish()
## # Check ECB
## assert(decrypted == data.to_utf8())
## var iv = "My secret iv!!!!" # IV must be of exactly 16 bytes.
## # Encrypt CBC
## aes.start(AESContext.MODE_CBC_ENCRYPT, key.to_utf8(), iv.to_utf8())
## encrypted = aes.update(data.to_utf8())
## aes.finish()
## # Decrypt CBC
## aes.start(AESContext.MODE_CBC_DECRYPT, key.to_utf8(), iv.to_utf8())
## decrypted = aes.update(encrypted)
## aes.finish()
## # Check CBC
## assert(decrypted == data.to_utf8())
## [/gdscript]
## [csharp]
## using Godot;
## using System.Diagnostics;
## public partial class MyNode : Node
## {
## private AesContext _aes = new AesContext();
## public override void _Ready()
## {
## string key = "My secret key!!!"; // Key must be either 16 or 32 bytes.
## string data = "My secret text!!"; // Data size must be multiple of 16 bytes, apply padding if needed.
## // Encrypt ECB
## _aes.Start(AesContext.Mode.EcbEncrypt, key.ToUtf8());
## byte[] encrypted = _aes.Update(data.ToUtf8());
## _aes.Finish();
## // Decrypt ECB
## _aes.Start(AesContext.Mode.EcbDecrypt, key.ToUtf8());
## byte[] decrypted = _aes.Update(encrypted);
## _aes.Finish();
## // Check ECB
## Debug.Assert(decrypted == data.ToUtf8());
## string iv = "My secret iv!!!!"; // IV must be of exactly 16 bytes.
## // Encrypt CBC
## _aes.Start(AesContext.Mode.EcbEncrypt, key.ToUtf8(), iv.ToUtf8());
## encrypted = _aes.Update(data.ToUtf8());
## _aes.Finish();
## // Decrypt CBC
## _aes.Start(AesContext.Mode.EcbDecrypt, key.ToUtf8(), iv.ToUtf8());
## decrypted = _aes.Update(encrypted);
## _aes.Finish();
## // Check CBC
## Debug.Assert(decrypted == data.ToUtf8());
## }
## }
## [/csharp]
## [/codeblocks]


## AES electronic codebook encryption mode.
## AES electronic codebook decryption mode.
## AES cipher blocker chaining encryption mode.
## AES cipher blocker chaining decryption mode.
## Maximum value for the mode enum.

#enum Mode
enum {
    MODE_ECB_ENCRYPT = 0,
    MODE_ECB_DECRYPT = 1,
    MODE_CBC_ENCRYPT = 2,
    MODE_CBC_DECRYPT = 3,
    MODE_MAX = 4,
}


## Close this AES context so it can be started again. See [method start].
func finish() -> void:
	pass;

## Get the current IV state for this context (IV gets updated when calling [method update]). You normally don't need this function.
## [b]Note:[/b] This function only makes sense when the context is started with [constant MODE_CBC_ENCRYPT] or [constant MODE_CBC_DECRYPT].
func get_iv_state() -> PackedByteArray:
	pass;

## Start the AES context in the given [param mode]. A [param key] of either 16 or 32 bytes must always be provided, while an [param iv] (initialization vector) of exactly 16 bytes, is only needed when [param mode] is either [constant MODE_CBC_ENCRYPT] or [constant MODE_CBC_DECRYPT].
func start(mode: int, key: PackedByteArray, iv: PackedByteArray = PackedByteArray()) -> int:
	pass;

## Run the desired operation for this AES context. Will return a [PackedByteArray] containing the result of encrypting (or decrypting) the given [param src]. See [method start] for mode of operation.
## [b]Note:[/b] The size of [param src] must be a multiple of 16. Apply some padding if needed.
func update(src: PackedByteArray) -> PackedByteArray:
	pass;


