import React, { useState } from 'react';
import useResizeObserver from 'use-resize-observer';
import { Sidebar } from '../Sidebar/Sidebar';
import { Info } from '../Info/Info';
import { Servers } from '../Servers/Servers';
import { Operations } from '../Operations/Operations';
import { Messages } from '../Messages/Messages';
import { Schemas } from '../Schemas/Schemas';
import { SpecificationContext, ConfigContext } from '../../contexts';
import AsyncApiErrorBoundary from '../ApplicationErrorHandler/ErrorBoundary';
var AsyncApiLayout = function (_a) {
    var _b, _c;
    var asyncapi = _a.asyncapi, config = _a.config;
    var _d = useState('container:xl'), observerClassName = _d[0], setObserverClassName = _d[1];
    var ref = useResizeObserver({
        onResize: function (_a) {
            var width = _a.width;
            requestAnimationFrame(function () {
                if (width === undefined) {
                    return;
                }
                var possibleClassName = width <= 1536 ? 'container:xl' : 'container:base';
                if (possibleClassName !== observerClassName) {
                    setObserverClassName(possibleClassName);
                }
            });
        },
    }).ref;
    var configShow = (_b = config.show) !== null && _b !== void 0 ? _b : {};
    return (React.createElement(ConfigContext.Provider, { value: config },
        React.createElement(SpecificationContext.Provider, { value: asyncapi },
            React.createElement("section", { className: "aui-root" },
                React.createElement(AsyncApiErrorBoundary, null,
                    React.createElement("div", { className: "".concat(observerClassName, " relative md:flex bg-white leading-normal"), id: (_c = config.schemaID) !== null && _c !== void 0 ? _c : undefined, ref: ref },
                        configShow.sidebar && React.createElement(Sidebar, null),
                        React.createElement("div", { className: "panel--center relative py-8 flex-1" },
                            React.createElement("div", { className: "relative z-10" },
                                configShow.info && React.createElement(Info, null),
                                configShow.servers && React.createElement(Servers, null),
                                configShow.operations && React.createElement(Operations, null),
                                configShow.messages && React.createElement(Messages, null),
                                configShow.schemas && React.createElement(Schemas, null)),
                            React.createElement("div", { className: "panel--right absolute top-0 right-0 h-full bg-gray-800" }))))))));
};
export default AsyncApiLayout;
//# sourceMappingURL=Layout.js.map