// ReSharper disable UnusedType.Global

using System;
using System.Collections.Generic;

namespace Learning
{
    public class Warehouse
    {
        // Fruit name to amount of it in warehouse
        private readonly Dictionary<string, int> _myFruits
            = new Dictionary<string, int>(); // Apple, banana, etc...

        public Warehouse()
        {
            var availableFruits = Utils.Fruits;
            foreach (var fruit in availableFruits) _myFruits.Add(fruit, 0);
        }

        //Add fruits from Utils.FRUITS (mango, apple...)

        public void AddFruits(string fruitName, int quantity)
        {
            _myFruits.TryGetValue(fruitName, out var curQuantity);
            _myFruits.Add(fruitName, curQuantity + quantity);
        }

        public bool TakeFruit(string fruitName)
        {
            _myFruits.TryGetValue(fruitName, out var curQuantity);
            if (curQuantity > 0)
            {
                _myFruits.Add(fruitName, curQuantity - 1);
                return true;
            }

            return false;
        }

        public void PrintAllFruits()
        {
            foreach (var entry in _myFruits)
            {
                Console.WriteLine(entry.Key + ": " + entry.Value);
            }
        }
    }
}