// ReSharper disable UnusedType.Global
// ReSharper disable ConvertIfStatementToSwitchStatement
// ReSharper disable MemberCanBePrivate.Global
// ReSharper disable UnusedMember.Global

using System;

namespace Learning
{
    public static class QuadraticEquationsSolver
    {
        private static double Discriminant(double a, double b, double c) {
            return b * b - 4 * a * c;
        }

        public static void Solve(double a, double b, double c) {
            var dsc = Discriminant(a, b, c);
            if (dsc < 0) {
                Console.WriteLine("No roots");
            } else if (dsc > 0) {
                var x1 = (-b + Math.Sqrt(dsc)) / (2.0 * a);
                var x2 = (-b - Math.Sqrt(dsc)) / (2.0 * a);
                Console.WriteLine("x1 = " + x1 + ", x2 = " + x2);
            } else {
                Console.WriteLine("x = " + (-b) / (2.0 * a));
            }
        }
    }
}