These files are used as dictionaries to provide Unity specific words to the spell checker. E.g. `gizmo`, `cubemap`, `raycast`, etc. The files are manually generated by the `DumpSpellCheckWordListsAction`, which is only available when running Rider in internal mode.

The `unity.dic` file is a list of the new words. The `unity.aff` file is empty, but required for ReSharper (Hunspell uses it as a set of rules for determining prefixes or suffixes. We don't use that). If it does not exist, the dictionary is not loaded by ReSharper.

The files are used differently by Rider and ReSharper.

* Rider includes `unity.dic` as a resource for a bundled dictionary. See [../rider/src/main/kotlin/com/jetbrains/rider/plugins/unity/spellchecker/UnityBundledDictionaryProvider.kt](UnityBundledDictionaryProvider.kt)
* ReSharper includes `unity.dic` and `unity.aff` on disk in the `DotFiles\Extensions\JetBrains.unity\dictionaries` folder. See [../resharper/resharper-unity/src/CSharp/Feature/Respeller/ReSharper/UnityInstalledDictionarySettingsProvider.cs](UnityInstalledDictionarySettingsProvider.cs)

The files are copied to the correct locations by the gradle scripts (for Rider), and the `.nuspec` file for ReSharper.

Note that there is also an `Abbreviations.txt`, but this is used by both the Rider backend and ReSharper, so is maintained at the location it's used.
