#!/bin/bash

OUTPUT_DIR=webrefJsons
# Recreate output directory
rm -rf ./$OUTPUT_DIR
mkdir -p ./$OUTPUT_DIR

# Base URL for raw GitHub content
BASE_URL="https://raw.githubusercontent.com/w3c/webref/curated/ed/css"

# Use GitHub API to get the list of files
FILES=$(curl -s "https://api.github.com/repos/w3c/webref/contents/ed/css?ref=curated" | grep '"name":' | grep '\.json"' | cut -d'"' -f4)
# Download each file
for file in $FILES; do
    echo "Downloading $file..."
    curl -s "$BASE_URL/$file" -o "$OUTPUT_DIR/$file"
done

echo "Download complete! Files are saved in the $OUTPUT_DIR directory."
