
### This page is created and built in [Vision](https://vision.jetbrains.dev/)

## Artifact contents

- `index.ID.html` – HTML file for previewing in the browser
- `vision-in-product-pages.json` – product page

## `vision-in-product-pages.json` contents

`entities` - Array of pages

| Field              | Description                                                                 |
|--------------------|-----------------------------------------------------------------------------|
| `id`             | Page ID in Vision                                                           |
| `actions`        | Array of action that can be called in the product via `window.jbCefQuery` |
| `languages`      | Array of language codes available for the page                              |
| `languagesShort` | Array of short language codes available for the page                        |
| `publicVars`     | Array of public variables from the product                                  |
| `html`           | String that includes HTML page with inline JS, CSS and images in base64.    |

For proper functioning you need to replace `publicVars` from your product in the `html` string.


## Page 5202

Page URL: https://vision.jetbrains.dev/preview-page/5202

Action list: 
- `StartDULTrialAction` – Start the trial
- `OpenAIAssistantAction` – Activate AI Assistant
- `InstallJunieAction` – Install Junie

Languages:
- `zh-cn` or `zh-CN`
- `ru-ru` or `ru`
- `pt-br` or `pt-BR`
- `ko-kr` or `ko`
- `ja-jp` or `ja`
- `fr-fr` or `fr`
- `es-es` or `es`
- `en-us` or `en`
- `de-de` or `de`

Public variables:
- `$__VISION_PAGE_SETTINGS_MEDIA_BASE_PATH__$` – Set medias base path where medias are serving. Default: '.'
- `$__VISION_PAGE_SETTINGS_LANGUAGE_CODE__$` – Set language code to display a page in selected language. Default: 'en-us'
- `$__VISION_PAGE_SETTINGS_THEME__$` – Set 'light' or 'dark' theme to match users' theme in a product. Default: 'light'
- `$__VISION_PAGE_SETTINGS_ZOOM_IN_ACTION__$` – Set ZoomIn action to be triggered when users click on images. Provided action will be called in window.jbCefQuery
- `$__VISION_PAGE_SETTINGS_GIF_PLAYER_ACTION__$` – Set GIF PLayer action to be triggered when users click on gif previews. Provided action will be called in window.jbCefQuery
- `$__VISION_PAGE_SETTINGS_IS_CHINESE__$` – Set to true if the page is displayed in Chinese
- `$__DAYS_LEFT__$` – Dynamic variable in the content: Days Left


