/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.svg;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssValue;

public class CssFillOpacity
extends org.w3c.css.properties.css.CssFillOpacity {
    private float clampedValue(ApplContext ac, float opacity) {
        if (opacity < 0.0f || opacity > 1.0f) {
            ac.getFrame().addWarning("out-of-range", Util.displayFloat(opacity));
            return opacity < 0.0f ? 0.0f : 1.0f;
        }
        return opacity;
    }

    public CssFillOpacity() {
        this.value = initial;
    }

    public CssFillOpacity(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue val = expression.getValue();
        char op = expression.getOperator();
        switch (val.getType()) {
            case 5: {
                if (val.getRawType() == 5) {
                    CssNumber number = val.getNumber();
                    number.setFloatValue(this.clampedValue(ac, number.getValue()));
                } else {
                    val.getCheckableValue().warnPositiveness(ac, this);
                }
                this.value = val;
                break;
            }
            case 0: {
                if (CssIdent.isCssWide(val.getIdent())) {
                    this.value = val;
                    break;
                }
            }
            default: {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
        }
        expression.next();
    }

    public CssFillOpacity(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }
}

