/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.psi.references;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexingBundle;
import com.jetbrains.plugins.jade.JadeToPugTransitionHelper;
import com.jetbrains.plugins.jade.psi.JadeFileType;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;
import com.jetbrains.plugins.jade.psi.impl.JadeFilePathImpl;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class JadeFileReferenceSet
extends FileReferenceSet {
    private final boolean myAllFiles;
    @NotNull
    private final String myExtension;

    public JadeFileReferenceSet(@NotNull JadeFilePathImpl element) {
        if (element == null) {
            JadeFileReferenceSet.$$$reportNull$$$0(0);
        }
        super((PsiElement)element);
        this.myAllFiles = element.getParent().getFirstChild().getNode().getElementType() == JadeTokenTypes.INCLUDE_KEYWORD;
        this.myExtension = JadeToPugTransitionHelper.isPugElement((PsiElement)element) ? "pug" : "jade";
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        FileTypeManager manager = FileTypeManager.getInstance();
        return psiFileSystemItem -> {
            if (psiFileSystemItem.isDirectory()) {
                return true;
            }
            if (this.getElement().getContainingFile().getOriginalFile().equals(psiFileSystemItem)) {
                return false;
            }
            return this.myAllFiles || manager.getFileTypeByFileName(psiFileSystemItem.getName()) instanceof JadeFileType;
        };
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        return new FileReference(this, range, index, text){

            protected Object createLookupItem(PsiElement candidate) {
                PsiFile file;
                block3: {
                    block2: {
                        if (!(candidate instanceof PsiFile)) break block2;
                        file = (PsiFile)candidate;
                        if (candidate.isPhysical()) break block3;
                    }
                    return candidate;
                }
                String name = file.getName();
                String lookupString = FileUtilRt.extensionEquals((String)name, (String)JadeFileReferenceSet.this.myExtension) ? FileUtilRt.getNameWithoutExtension((String)name) : name;
                return LookupElementBuilder.create((Object)file, (String)lookupString).withIcon(file.getIcon(0)).withPresentableText(name);
            }

            @NlsSafe
            private String patchText(String text) {
                if (!this.isLast()) {
                    return text;
                }
                String extension = FileUtilRt.getExtension((String)text);
                if (JadeFileReferenceSet.this.myAllFiles && !extension.isEmpty()) {
                    return text;
                }
                if (ContainerUtil.find(JadeToPugTransitionHelper.ALL_EXTENSIONS, name -> FileUtil.namesEqual((String)name, (String)extension)) == null) {
                    return text + "." + JadeFileReferenceSet.this.myExtension;
                }
                return text;
            }

            protected void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, @NotNull Collection<? super ResolveResult> result, boolean caseSensitive) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.innerResolveInContext(this.patchText(text), context, result, caseSensitive);
            }

            @NotNull
            public String getFileNameToCreate() {
                String string = this.patchText(this.getCanonicalText());
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            @NotNull
            @Nls(capitalization=Nls.Capitalization.Sentence)
            public String getUnresolvedMessagePattern() {
                String text = StringUtil.escapePattern((String)this.decode(this.getCanonicalText()));
                String string = AnalysisBundle.message((String)"error.cannot.resolve.file.or.dir", (Object[])new Object[]{IndexingBundle.message((String)(this.isLast() ? "terms.file" : "terms.directory"), (Object[])new Object[0]), this.patchText(text)});
                if (string == null) {
                    1.$$$reportNull$$$0(4);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/plugins/jade/psi/references/JadeFileReferenceSet$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/plugins/jade/psi/references/JadeFileReferenceSet$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFileNameToCreate";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUnresolvedMessagePattern";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "innerResolveInContext";
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3, 4 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/plugins/jade/psi/references/JadeFileReferenceSet", "<init>"));
    }
}

