/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.lexer;

import com.intellij.embedding.EmbeddedLazyParseableElementType;
import com.intellij.html.embedding.HtmlEmbeddedContentSupport;
import com.intellij.html.embedding.HtmlEmbedmentInfo;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lexer.DummyLexer;
import com.intellij.lexer.EmbeddedTokenTypesProvider;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.SyntaxHighlighterLanguageFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.impl.util.CssStylesheetLazyElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.jetbrains.plugins.jade.highlighter.JadeSyntaxHighlighter;
import com.jetbrains.plugins.jade.lexer.JadeEmbeddedTokenTypesWrapper;
import com.jetbrains.plugins.jade.lexer.JadeEmbeddedTokenTypesWrapperForCssStylesheet;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JadeEmbeddingUtil {
    private static final Logger LOG = Logger.getInstance(JadeEmbeddingUtil.class);
    private static final IElementType XML_DATA_CHARACTERS_LAZY_TYPE = new DummyEmbeddedType("XML_DATA_CHARACTERS", XmlTokenType.XML_DATA_CHARACTERS);

    @NotNull
    public static IElementType getEmbeddedTokenWrapperType(@NotNull IElementType embeddedTokenType) {
        if (embeddedTokenType == null) {
            JadeEmbeddingUtil.$$$reportNull$$$0(0);
        }
        IElementType iElementType = ((WrappersForEmbeddedTypesService)ApplicationManager.getApplication().getService(WrappersForEmbeddedTypesService.class)).getEmbeddedTokenWrapperType(embeddedTokenType);
        if (iElementType == null) {
            JadeEmbeddingUtil.$$$reportNull$$$0(1);
        }
        return iElementType;
    }

    @NotNull
    public static SyntaxHighlighter getHighlighterForLanguage(@NotNull Language language) {
        if (language == null) {
            JadeEmbeddingUtil.$$$reportNull$$$0(2);
        }
        SyntaxHighlighter syntaxHighlighter = (SyntaxHighlighter)SyntaxHighlighterLanguageFactory.EP_NAME.computeIfAbsent((Object)language, JadeEmbeddingUtil.class, it -> SyntaxHighlighterFactory.getSyntaxHighlighter((Language)it, null, null));
        if (syntaxHighlighter == null) {
            JadeEmbeddingUtil.$$$reportNull$$$0(3);
        }
        return syntaxHighlighter;
    }

    private static IElementType createWrapper(IElementType token) {
        if (token instanceof CssStylesheetLazyElementType) {
            return new JadeEmbeddedTokenTypesWrapperForCssStylesheet((CssStylesheetLazyElementType)token);
        }
        return new JadeEmbeddedTokenTypesWrapper(token);
    }

    @Nullable
    public static IElementType getElementToEmbedForATag(@Nullable String tagName, @Nullable Map<String, String> attributes) {
        if (!StringUtil.equalsIgnoreCase((CharSequence)tagName, (CharSequence)"script")) {
            return null;
        }
        if (attributes == null || !attributes.containsKey("type")) {
            return null;
        }
        String mimeType = JadeEmbeddingUtil.sanitizeAttrValue(attributes.get("type"));
        if (StringUtil.isEmpty((String)mimeType)) {
            return null;
        }
        List<HTMLLanguage> instancesByMimeType = Language.findInstancesByMimeType((String)mimeType.trim());
        if (instancesByMimeType.isEmpty() && mimeType.contains("template")) {
            instancesByMimeType = Collections.singletonList(HTMLLanguage.INSTANCE);
        }
        IElementType result = null;
        for (Language language : instancesByMimeType) {
            HtmlEmbedmentInfo embedmentInfo = HtmlEmbeddedContentSupport.getScriptTagEmbedmentInfo((Language)language);
            if (embedmentInfo == null) continue;
            if (result != null) {
                Logger.getInstance(JadeEmbeddingUtil.class).warn("Multiple script content providers for a type: " + mimeType);
            }
            result = embedmentInfo.getElementType();
        }
        if (result == null) {
            result = XML_DATA_CHARACTERS_LAZY_TYPE;
        }
        return result;
    }

    @Nullable
    public static IElementType getElementToEmbedForFilterName(String filterName) {
        for (EmbeddedTokenTypesProvider embeddedTokenTypesProvider : EmbeddedTokenTypesProvider.getProviders()) {
            if (!filterName.startsWith(embeddedTokenTypesProvider.getName())) continue;
            return embeddedTokenTypesProvider.getElementType();
        }
        return null;
    }

    @Contract(value="!null -> !null")
    @Nullable
    private static String sanitizeAttrValue(@Nullable String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 2) {
            return value;
        }
        if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embeddedTokenType";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/jade/lexer/JadeEmbeddingUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/jade/lexer/JadeEmbeddingUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmbeddedTokenWrapperType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighterForLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEmbeddedTokenWrapperType";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHighlighterForLanguage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    @Service
    private static final class WrappersForEmbeddedTypesService
    implements Disposable {
        private final Map<IElementType, IElementType> myWrappersForEmbeddedTypes = new ConcurrentHashMap<IElementType, IElementType>();

        private WrappersForEmbeddedTypesService() {
            this.getOrCreateEmbeddedTokenWrapperType(XML_DATA_CHARACTERS_LAZY_TYPE);
            this.getOrCreateEmbeddedTokenWrapperType(XmlElementType.HTML_EMBEDDED_CONTENT);
            this.getOrCreateEmbeddedTokenWrapperType(JadeTokenTypes.STYLE_BLOCK);
            EmbeddedTokenTypesProvider.EXTENSION_POINT_NAME.getPoint().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<EmbeddedTokenTypesProvider>(){

                public void extensionAdded(@NotNull EmbeddedTokenTypesProvider provider, @NotNull PluginDescriptor pluginDescriptor) {
                    if (provider == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (pluginDescriptor == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    JadeSyntaxHighlighter.registerEmbeddedToken(this.getOrCreateEmbeddedTokenWrapperType(provider.getElementType()));
                }

                public void extensionRemoved(@NotNull EmbeddedTokenTypesProvider provider, @NotNull PluginDescriptor pluginDescriptor) {
                    IElementType wrapper;
                    if (provider == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (pluginDescriptor == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if ((wrapper = myWrappersForEmbeddedTypes.remove(provider.getElementType())) != null) {
                        JadeSyntaxHighlighter.unregisterEmbeddedToken(wrapper);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "provider";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "pluginDescriptor";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/plugins/jade/lexer/JadeEmbeddingUtil$WrappersForEmbeddedTypesService$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionAdded";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionRemoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, true, (Disposable)this);
        }

        @NotNull
        public IElementType getEmbeddedTokenWrapperType(@NotNull IElementType embeddedTokenType) {
            IElementType wrapper;
            if (embeddedTokenType == null) {
                WrappersForEmbeddedTypesService.$$$reportNull$$$0(0);
            }
            if ((wrapper = this.myWrappersForEmbeddedTypes.get(embeddedTokenType)) != null) {
                IElementType iElementType = wrapper;
                if (iElementType == null) {
                    WrappersForEmbeddedTypesService.$$$reportNull$$$0(1);
                }
                return iElementType;
            }
            LOG.error("Embedded token type " + String.valueOf(embeddedTokenType) + " has not been registered through extension point.");
            return this.getOrCreateEmbeddedTokenWrapperType(embeddedTokenType);
        }

        @NotNull
        private IElementType getOrCreateEmbeddedTokenWrapperType(@NotNull IElementType embeddedTokenType) {
            if (embeddedTokenType == null) {
                WrappersForEmbeddedTypesService.$$$reportNull$$$0(2);
            }
            IElementType iElementType = this.myWrappersForEmbeddedTypes.computeIfAbsent(embeddedTokenType, JadeEmbeddingUtil::createWrapper);
            if (iElementType == null) {
                WrappersForEmbeddedTypesService.$$$reportNull$$$0(3);
            }
            return iElementType;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "embeddedTokenType";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/jade/lexer/JadeEmbeddingUtil$WrappersForEmbeddedTypesService";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/jade/lexer/JadeEmbeddingUtil$WrappersForEmbeddedTypesService";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEmbeddedTokenWrapperType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateEmbeddedTokenWrapperType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getEmbeddedTokenWrapperType";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrCreateEmbeddedTokenWrapperType";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class DummyEmbeddedType
    extends EmbeddedLazyParseableElementType {
        @NotNull
        private final IElementType myTokenType;

        private DummyEmbeddedType(@NotNull @NonNls String debugName, @NotNull IElementType containingTokenType) {
            if (debugName == null) {
                DummyEmbeddedType.$$$reportNull$$$0(0);
            }
            if (containingTokenType == null) {
                DummyEmbeddedType.$$$reportNull$$$0(1);
            }
            super(debugName, containingTokenType.getLanguage());
            this.myTokenType = containingTokenType;
        }

        public Lexer createLexer(@NotNull ASTNode chameleon, @NotNull Project project) {
            if (chameleon == null) {
                DummyEmbeddedType.$$$reportNull$$$0(2);
            }
            if (project == null) {
                DummyEmbeddedType.$$$reportNull$$$0(3);
            }
            return new DummyLexer(this.myTokenType);
        }

        public ASTNode parseAndGetTree(@NotNull PsiBuilder builder) {
            if (builder == null) {
                DummyEmbeddedType.$$$reportNull$$$0(4);
            }
            PsiBuilder.Marker marker = builder.mark();
            while (!builder.eof()) {
                builder.advanceLexer();
            }
            marker.done((IElementType)this);
            return builder.getTreeBuilt();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingTokenType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chameleon";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/plugins/jade/lexer/JadeEmbeddingUtil$DummyEmbeddedType";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createLexer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseAndGetTree";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

