/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.js;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.ecmascript6.parsing.ES6StatementParser;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.plugins.jade.JadeBundle;
import com.jetbrains.plugins.jade.js.JavaScriptInJadeParser;
import com.jetbrains.plugins.jade.psi.JadeElementTypes;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;

public class JavaScriptInJadeStatementParser
extends ES6StatementParser<JavaScriptInJadeParser> {
    protected JavaScriptInJadeStatementParser(JavaScriptInJadeParser parser) {
        super((ES6Parser)parser);
    }

    public boolean parseBlock() {
        PsiBuilder.Marker mark = this.builder.mark();
        this.parseBlockAndAttachStatementsDirectly();
        mark.done(JSElementTypes.BLOCK_STATEMENT_EAGER);
        return true;
    }

    public void parseStatement() {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == null) {
            this.builder.error(JavaScriptParserBundle.message((String)"javascript.parser.message.expected.statement", (Object[])new Object[0]));
            return;
        }
        if (firstToken == JSTokenTypes.WHILE_KEYWORD || firstToken == JSTokenTypes.FOR_KEYWORD || firstToken == JSTokenTypes.EACH_KEYWORD) {
            this.parseMyIterationStatement();
            return;
        }
        super.parseStatement();
    }

    void parseEachStatement(boolean canGoFurther) {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.EACH_KEYWORD || this.builder.getTokenType() == JSTokenTypes.FOR_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        if (!this.markVariable(false)) {
            this.builder.mark().error(JavaScriptParserBundle.message((String)"javascript.parser.message.expected.variable.name", (Object[])new Object[0]));
            statement.done(JadeTokenTypes.EACH_EXPR);
            return;
        }
        if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
            this.builder.advanceLexer();
            if (!this.markVariable(false)) {
                this.builder.mark().error(JavaScriptParserBundle.message((String)"javascript.parser.message.expected.variable.name", (Object[])new Object[0]));
                statement.done(JadeTokenTypes.EACH_EXPR);
                return;
            }
        }
        JavaScriptInJadeStatementParser.checkMatches((PsiBuilder)this.builder, (IElementType)JSTokenTypes.IN_KEYWORD, (String)"javascript.parser.message.expected.forloop.in.or.semicolon");
        ((JavaScriptInJadeParser)this.parser).getExpressionParser().parseExpression();
        if (canGoFurther && !this.isEndReached()) {
            this.parseStatement();
            if (this.builder.getTokenType() == JSTokenTypes.ELSE_KEYWORD) {
                this.builder.advanceLexer();
                this.parseStatement();
            }
        } else if (!canGoFurther && !this.isEndReached()) {
            this.builder.mark().error(JadeBundle.message("pug.parser.error.indent-expected", new Object[0]));
        }
        statement.done(JadeTokenTypes.EACH_EXPR);
    }

    void parseMixinParameterList(boolean isDeclaration) {
        PsiBuilder.Marker statement = this.builder.mark();
        boolean lParPassed = JavaScriptInJadeStatementParser.checkMatches((PsiBuilder)this.builder, (IElementType)JSTokenTypes.LPAR, (String)"javascript.parser.message.expected.lparen");
        LOG.assertTrue(lParPassed);
        boolean isFirst = true;
        boolean seenRest = false;
        while (!this.builder.eof()) {
            IElementType tokenType = this.builder.getTokenType();
            if (tokenType == JSTokenTypes.RPAR) {
                this.builder.advanceLexer();
                break;
            }
            if (seenRest) {
                this.builder.error(JavaScriptParserBundle.message((String)"javascript.parser.message.expected.rparen", (Object[])new Object[0]));
            }
            if (isFirst) {
                isFirst = false;
            } else {
                boolean commaPassed = JavaScriptInJadeStatementParser.checkMatches((PsiBuilder)this.builder, (IElementType)JSTokenTypes.COMMA, (String)"javascript.parser.message.expected.comma.or.rparen");
                if (!commaPassed) break;
            }
            if (isDeclaration) {
                seenRest |= this.passRest();
                if (((JavaScriptInJadeParser)this.parser).getFunctionParser().willParseDestructuringAssignment()) {
                    PsiBuilder.Marker marker = this.builder.mark();
                    IElementType elementType = ((JavaScriptInJadeParser)this.parser).getExpressionParser().parseDestructuringElementNoMarker(this.getVariableElementType(), true, true);
                    marker.done(elementType);
                    marker.precede().done(JSElementTypes.VAR_STATEMENT);
                    continue;
                }
                boolean variableMarked = this.markVariable(true);
                if (variableMarked) continue;
                break;
            }
            boolean expressionParsed = ((JavaScriptInJadeParser)this.parser).getExpressionParser().parseAssignmentExpression(false);
            if (expressionParsed) continue;
            this.builder.error(JavaScriptParserBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            break;
        }
        statement.done(isDeclaration ? JadeElementTypes.MIXIN_PARAMETERS : JadeElementTypes.MIXIN_PARAMETERS_VALUES);
    }

    private boolean passRest() {
        if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
            this.builder.advanceLexer();
            return true;
        }
        return false;
    }

    boolean markVariable(boolean allowInitializer) {
        PsiBuilder.Marker varStatement = this.builder.mark();
        PsiBuilder.Marker varMarker = this.builder.mark();
        if (!this.parseVarName(varMarker)) {
            varStatement.drop();
            return false;
        }
        ((JavaScriptInJadeParser)this.parser).getTypeParser().tryParseType();
        if (this.builder.getTokenType() == JSTokenTypes.EQ && allowInitializer) {
            this.parseVariableInitializer(false);
        }
        varMarker.done(this.getVariableElementType());
        varMarker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        varStatement.done(JSElementTypes.VAR_STATEMENT);
        return true;
    }

    private void parseMyIterationStatement() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.WHILE_KEYWORD) {
            this.parseMyWhileStatement();
        } else if (tokenType == JSTokenTypes.EACH_KEYWORD || tokenType == JSTokenTypes.FOR_KEYWORD && this.builder.lookAhead(1) != JSTokenTypes.EACH_KEYWORD && this.builder.lookAhead(1) != JSTokenTypes.LPAR) {
            this.parseEachStatement(true);
        } else if (tokenType == JSTokenTypes.FOR_KEYWORD) {
            this.parseMyForStatement();
        }
    }

    private void parseMyForStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.FOR_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        boolean forin = this.parseForLoopHeader();
        if (!this.isEndReached()) {
            this.parseStatement();
            if (this.builder.getTokenType() == JSTokenTypes.ELSE_KEYWORD) {
                this.builder.advanceLexer();
                this.parseStatement();
            }
        }
        statement.done(forin ? JSElementTypes.FOR_IN_STATEMENT : JSElementTypes.FOR_STATEMENT);
    }

    private void parseMyWhileStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.WHILE_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        JavaScriptInJadeStatementParser.checkMatches((PsiBuilder)this.builder, (IElementType)JSTokenTypes.LPAR, (String)"javascript.parser.message.expected.lparen");
        ((JavaScriptInJadeParser)this.parser).getExpressionParser().parseExpression();
        JavaScriptInJadeStatementParser.checkMatches((PsiBuilder)this.builder, (IElementType)JSTokenTypes.RPAR, (String)"javascript.parser.message.expected.rparen");
        if (!this.isEndReached()) {
            this.parseStatement();
        }
        statement.done(JSElementTypes.WHILE_STATEMENT);
    }

    private boolean isEndReached() {
        return this.builder.getTokenType() == null;
    }
}

