/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.highlighter;

import com.intellij.ide.highlighter.EmbeddedTokenHighlighter;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.plugins.jade.JadeLanguage;
import com.jetbrains.plugins.jade.highlighter.JadeHighlighter;
import com.jetbrains.plugins.jade.lexer.JadeEmbeddingUtil;
import com.jetbrains.plugins.jade.lexer.JadeHighlightingLexer;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public final class JadeSyntaxHighlighter
extends SyntaxHighlighterBase
implements SyntaxHighlighter {
    private static final Map<IElementType, TextAttributesKey> ATTRIBUTES = new ConcurrentHashMap<IElementType, TextAttributesKey>();
    private final CodeStyleSettings myCodeStyleSettings;

    public JadeSyntaxHighlighter(CodeStyleSettings codeStyleSettings) {
        this.myCodeStyleSettings = codeStyleSettings;
    }

    private static void put(IElementType token, TextAttributesKey value) {
        if (ATTRIBUTES.put(token, value) != null) {
            Logger.getInstance(JadeSyntaxHighlighter.class).error("ALREADY MAPPED: " + String.valueOf(token));
        }
    }

    public static void registerEmbeddedToken(IElementType wrapper) {
        JadeSyntaxHighlighter.put(wrapper, JadeHighlighter.EMBEDDED_CONTENT);
    }

    public static void unregisterEmbeddedToken(IElementType wrapper) {
        ATTRIBUTES.remove(wrapper);
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new JadeHighlightingLexer(this.myCodeStyleSettings);
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey ownResult = ATTRIBUTES.get(tokenType);
        if (tokenType.getLanguage() == JadeLanguage.INSTANCE || ownResult != null) {
            TextAttributesKey[] textAttributesKeyArray = JadeSyntaxHighlighter.pack((TextAttributesKey)ownResult);
            if (textAttributesKeyArray == null) {
                JadeSyntaxHighlighter.$$$reportNull$$$0(0);
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = JadeEmbeddingUtil.getHighlighterForLanguage(tokenType.getLanguage()).getTokenHighlights(tokenType);
        if (textAttributesKeyArray == null) {
            JadeSyntaxHighlighter.$$$reportNull$$$0(1);
        }
        return textAttributesKeyArray;
    }

    static {
        JadeSyntaxHighlighter.put(JadeTokenTypes.COMMENT, JadeHighlighter.COMMENT);
        JadeSyntaxHighlighter.put(JadeTokenTypes.UNBUF_COMMENT, JadeHighlighter.UNBUF_COMMENT);
        JadeSyntaxHighlighter.put(JadeTokenTypes.DOCTYPE_KEYWORD, JadeHighlighter.DOCTYPE_KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.TEXT, JadeHighlighter.TEXT);
        JadeSyntaxHighlighter.put(JadeTokenTypes.STRING_LITERAL, JadeHighlighter.TEXT);
        JadeSyntaxHighlighter.put(JadeTokenTypes.CHAR_LITERAL, JadeHighlighter.TEXT);
        JadeSyntaxHighlighter.put(JadeTokenTypes.TAG_NAME, JadeHighlighter.TAG_NAME);
        JadeSyntaxHighlighter.put(JadeTokenTypes.ATTRIBUTE_NAME, JadeHighlighter.ATTRIBUTE_NAME);
        JadeSyntaxHighlighter.put(JadeTokenTypes.ATTRIBUTES_KEYWORD, JadeHighlighter.ATTRIBUTE_NAME);
        JadeSyntaxHighlighter.put(JadeTokenTypes.TAG_ID, JadeHighlighter.TAG_ID);
        JadeSyntaxHighlighter.put(JadeTokenTypes.TAG_CLASS, JadeHighlighter.TAG_CLASS);
        JadeSyntaxHighlighter.put(JadeTokenTypes.BAD_CHARACTER, JadeHighlighter.BAD_CHARACTER);
        JadeSyntaxHighlighter.put(JadeTokenTypes.NUMBER, JadeHighlighter.NUMBER);
        JadeSyntaxHighlighter.put(JadeTokenTypes.PIPE, JadeHighlighter.PIPE);
        JadeSyntaxHighlighter.put(JadeTokenTypes.COMMA, JadeHighlighter.COMMA);
        JadeSyntaxHighlighter.put(JadeTokenTypes.LPAREN, JadeHighlighter.PARENTS);
        JadeSyntaxHighlighter.put(JadeTokenTypes.RPAREN, JadeHighlighter.PARENTS);
        JadeSyntaxHighlighter.put(JadeTokenTypes.COLON, JadeHighlighter.COLON);
        JadeSyntaxHighlighter.put(JadeTokenTypes.MINUS, JadeHighlighter.OPERATION_SIGN);
        JadeSyntaxHighlighter.put(JadeTokenTypes.EQ, JadeHighlighter.OPERATION_SIGN);
        JadeSyntaxHighlighter.put(JadeTokenTypes.NEQ, JadeHighlighter.OPERATION_SIGN);
        JadeSyntaxHighlighter.put(JadeTokenTypes.COND_KEYWORD, JadeHighlighter.KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.ELSE_KEYWORD, JadeHighlighter.KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.ITERATION_KEYWORD, JadeHighlighter.KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.CASE, JadeHighlighter.KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.WHEN, JadeHighlighter.KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.DEFAULT_KEYWORD, JadeHighlighter.KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.EXTENDS_KEYWORD, JadeHighlighter.KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.FILE_PATH, JadeHighlighter.FILE_PATH);
        JadeSyntaxHighlighter.put(JadeTokenTypes.INCLUDE_KEYWORD, JadeHighlighter.KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.YIELD_KEYWORD, JadeHighlighter.KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.MIXIN_KEYWORD, JadeHighlighter.KEYWORD);
        JadeSyntaxHighlighter.put(JadeTokenTypes.FILTER_NAME, JadeHighlighter.FILTER_NAME);
        for (IElementType type : JadeTokenTypes.JS_TOKENS.getTypes()) {
            JadeSyntaxHighlighter.put(type, JadeHighlighter.JS_BLOCK);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/highlighter/JadeSyntaxHighlighter", "getTokenHighlights"));
    }

    public static final class XmlTokenHighlighter
    implements EmbeddedTokenHighlighter {
        @NotNull
        public MultiMap<IElementType, TextAttributesKey> getEmbeddedTokenAttributes() {
            MultiMap map = MultiMap.create();
            map.putAllValues(ATTRIBUTES);
            MultiMap multiMap = map;
            if (multiMap == null) {
                XmlTokenHighlighter.$$$reportNull$$$0(0);
            }
            return multiMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/highlighter/JadeSyntaxHighlighter$XmlTokenHighlighter", "getEmbeddedTokenAttributes"));
        }
    }
}

